/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.TestDelayFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.TestModuleRepository;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="factories.ComponentRegistryTest")
public class ComponentRegistryTest
extends AbstractInfinispanTest {
    private ComponentRegistry cr1;
    private ComponentRegistry cr2;
    private TestDelayFactory.Control control;

    @BeforeMethod
    public void setUp() throws InterruptedException, ExecutionException {
        GlobalConfiguration gc = new GlobalConfigurationBuilder().build();
        Configuration c = new ConfigurationBuilder().build();
        HashSet cachesSet = new HashSet();
        EmbeddedCacheManager cm = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        GlobalComponentRegistry gcr = new GlobalComponentRegistry(gc, cm, cachesSet, TestModuleRepository.defaultModuleRepository(), (ConfigurationManager)Mockito.mock(ConfigurationManager.class));
        this.cr1 = new ComponentRegistry("cache", c, cache, gcr, ComponentRegistryTest.class.getClassLoader());
        this.cr2 = new ComponentRegistry("cache", c, cache, gcr, ComponentRegistryTest.class.getClassLoader());
        this.control = new TestDelayFactory.Control();
        gcr.registerComponent((Object)this.control, TestDelayFactory.Control.class);
    }

    public void testSingleThreadLookup() {
        this.control.unblock();
        TestDelayFactory.Component c1 = (TestDelayFactory.Component)this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
        Assert.assertNotNull((Object)c1);
        TestDelayFactory.Component c2 = (TestDelayFactory.Component)this.cr1.getOrCreateComponent(TestDelayFactory.Component.class);
        Assert.assertNotNull((Object)c2);
    }

    public void testConcurrentLookupSameComponentRegistry() throws Exception {
        this.testConcurrentLookup(this.cr1, this.cr2);
    }

    public void testConcurrentLookupDifferentComponentRegistries() throws Exception {
        this.testConcurrentLookup(this.cr1, this.cr2);
    }

    private void testConcurrentLookup(ComponentRegistry cr1, ComponentRegistry cr2) throws Exception {
        Future<TestDelayFactory.Component> future1 = this.fork(() -> (TestDelayFactory.Component)cr1.getOrCreateComponent(TestDelayFactory.Component.class));
        Future<TestDelayFactory.Component> future2 = this.fork(() -> (TestDelayFactory.Component)cr2.getOrCreateComponent(TestDelayFactory.Component.class));
        Thread.sleep(500L);
        AssertJUnit.assertFalse((boolean)future1.isDone());
        AssertJUnit.assertFalse((boolean)future2.isDone());
        this.control.unblock();
        Assert.assertNotNull((Object)future1.get());
        Assert.assertNotNull((Object)future2.get());
    }

    public void testGetLocalComponent() {
        GlobalComponentRegistry localGcr = (GlobalComponentRegistry)this.cr1.getLocalComponent(GlobalComponentRegistry.class);
        AssertJUnit.assertNull((Object)localGcr);
    }
}

