/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.math.BigInteger;
import java.util.Arrays;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

final class NativeBigInt
extends ScriptableObject {
    private static final long serialVersionUID = 1335609231306775449L;
    private static final String CLASS_NAME = "BigInt";
    private final BigInteger bigIntValue;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, NativeBigInt::js_constructorFunc, NativeBigInt::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.defineConstructorMethod(scope, "asIntN", 2, (lcx, lscope, thisObj, args) -> NativeBigInt.js_asIntOrUintN(true, args), 2, 3);
        constructor.defineConstructorMethod(scope, "asUintN", 2, (lcx, lscope, thisObj, args) -> NativeBigInt.js_asIntOrUintN(false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "toString", 0, NativeBigInt::js_toString, 2, 3);
        constructor.definePrototypeMethod(scope, "toLocaleString", 0, NativeBigInt::js_toString, 2, 3);
        constructor.definePrototypeMethod(scope, "toSource", 0, NativeBigInt::js_toSource, 2, 3);
        constructor.definePrototypeMethod(scope, "valueOf", 0, (lcx, lscope, thisObj, args) -> NativeBigInt.toSelf((Scriptable)thisObj).bigIntValue, 2, 3);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    NativeBigInt(BigInteger bigInt) {
        this.bigIntValue = bigInt;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static NativeBigInt toSelf(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeBigInt.class);
    }

    private static Object js_constructorFunc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return args.length >= 1 ? ScriptRuntime.toBigInt(args[0]) : BigInteger.ZERO;
    }

    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeErrorById("msg.no.new", CLASS_NAME);
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int base = args.length == 0 || args[0] == Undefined.instance ? 10 : ScriptRuntime.toInt32(args[0]);
        BigInteger value = NativeBigInt.toSelf((Scriptable)thisObj).bigIntValue;
        return ScriptRuntime.bigIntToString(value, base);
    }

    private static Object js_toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return "(new BigInt(" + ScriptRuntime.toString(NativeBigInt.toSelf((Scriptable)thisObj).bigIntValue) + "))";
    }

    private static Object js_asIntOrUintN(boolean isSigned, Object[] args) {
        int bits = ScriptRuntime.toIndex(args.length < 1 ? Undefined.instance : args[0]);
        BigInteger bigInt = ScriptRuntime.toBigInt(args.length < 2 ? Undefined.instance : args[1]);
        if (bits == 0) {
            return BigInteger.ZERO;
        }
        int newBytesLen = bits / 8 + 1;
        byte[] bytes = bigInt.toByteArray();
        if (newBytesLen > bytes.length) {
            return bigInt;
        }
        byte[] newBytes = Arrays.copyOfRange(bytes, bytes.length - newBytesLen, bytes.length);
        int mod = bits % 8;
        newBytes[0] = isSigned ? (mod == 0 ? (newBytes[1] < 0 ? -1 : 0) : ((newBytes[0] & 1 << mod - 1) != 0 ? (byte)(newBytes[0] | -1 << mod) : (byte)(newBytes[0] & (1 << mod) - 1))) : (byte)(newBytes[0] & (1 << mod) - 1);
        return new BigInteger(newBytes);
    }

    public String toString() {
        return ScriptRuntime.bigIntToString(this.bigIntValue, 10);
    }
}

