/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.search.engine.cfg.impl.EmptyConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.FallbackConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.ListeningConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.MapConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.MaskedConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.OverriddenConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.PrefixedConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.SystemConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;

public interface ConfigurationPropertySource {
    public Optional<?> get(String var1);

    public Optional<String> resolve(String var1);

    default public ConfigurationPropertySource withPrefix(String prefix) {
        return new PrefixedConfigurationPropertySource(this, prefix);
    }

    default public ConfigurationPropertySource withMask(String mask) {
        return new MaskedConfigurationPropertySource(this, mask);
    }

    default public ConfigurationPropertySource withFallback(ConfigurationPropertySource fallback) {
        return new FallbackConfigurationPropertySource(this, fallback);
    }

    default public ConfigurationPropertySource withOverride(ConfigurationPropertySource override) {
        return new OverriddenConfigurationPropertySource(this, override);
    }

    default public ConfigurationPropertySource onGet(Consumer<String> listener) {
        return new ListeningConfigurationPropertySource(this, listener);
    }

    public static AllAwareConfigurationPropertySource fromMap(Map<String, ?> map) {
        return new MapConfigurationPropertySource(map);
    }

    public static AllAwareConfigurationPropertySource system() {
        return SystemConfigurationPropertySource.get();
    }

    public static ConfigurationPropertySource empty() {
        return EmptyConfigurationPropertySource.get();
    }
}

