/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TextTermsCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;

public class TextTermsCollectorFactory
implements CollectorFactory<TextTermsCollector, TermResults, TextTermsCollectorManager> {
    public final CollectorKey<TextTermsCollector, TermResults> key = CollectorKey.create();
    private final TextMultiValuesSource valuesSource;
    private final String field;
    private final List<CollectorFactory<?, ?, ?>> collectorFactories;

    public static CollectorFactory<TextTermsCollector, TermResults, TextTermsCollectorManager> instance(String field, TextMultiValuesSource valuesSource, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        return new TextTermsCollectorFactory(field, valuesSource, collectorFactories);
    }

    public TextTermsCollectorFactory(String field, TextMultiValuesSource valuesSource, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        this.field = field;
        this.valuesSource = valuesSource;
        this.collectorFactories = collectorFactories;
    }

    @Override
    public TextTermsCollectorManager createCollectorManager(CollectorExecutionContext context) throws IOException {
        CollectorKey[] keys = new CollectorKey[this.collectorFactories.size()];
        CollectorManager[] managers = new CollectorManager[this.collectorFactories.size()];
        int index = 0;
        for (CollectorFactory<?, ?, ?> factory : this.collectorFactories) {
            keys[index] = factory.getCollectorKey();
            Object collectorManager = factory.createCollectorManager(context);
            managers[index] = collectorManager;
            ++index;
        }
        return new TextTermsCollectorManager(this.field, this.valuesSource, keys, managers);
    }

    @Override
    public CollectorKey<TextTermsCollector, TermResults> getCollectorKey() {
        return this.key;
    }
}

