/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldFieldCodec;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.IndexFieldType;

class LuceneNativeIndexFieldTypeOptionsStep<F>
extends AbstractLuceneIndexFieldTypeOptionsStep<LuceneNativeIndexFieldTypeOptionsStep<F>, F> {
    private final LuceneFieldContributor<F> fieldContributor;
    private final LuceneFieldValueExtractor<F> fieldValueExtractor;

    LuceneNativeIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, Class<F> fieldType, LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        super(buildContext, fieldType);
        this.fieldContributor = fieldContributor;
        this.fieldValueExtractor = fieldValueExtractor;
    }

    public IndexFieldType<F> toIndexFieldType() {
        LuceneFieldFieldCodec<F> codec = new LuceneFieldFieldCodec<F>(this.fieldContributor, this.fieldValueExtractor);
        this.builder.codec(codec);
        if (this.fieldValueExtractor != null) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<F>(codec));
        }
        return this.builder.build();
    }

    @Override
    protected LuceneNativeIndexFieldTypeOptionsStep<F> thisAsS() {
        return this;
    }
}

