/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.c3p0.internal;

import java.sql.SQLException;
import org.hibernate.internal.log.ConnectionPoolingLogger;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.connections.pooling.c3p0", description="Logging related to the C3P0 connection pool")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10001, max=15000)
public interface C3P0MessageLogger
extends ConnectionPoolingLogger {
    public static final String NAME = "org.hibernate.orm.connections.pooling.c3p0";
    public static final Logger C3P0_LOGGER = Logger.getLogger((String)"org.hibernate.orm.connections.pooling.c3p0");
    public static final C3P0MessageLogger C3P0_MSG_LOGGER = (C3P0MessageLogger)Logger.getMessageLogger(C3P0MessageLogger.class, (String)"org.hibernate.orm.connections.pooling.c3p0");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Both hibernate-style property '%1$s' and c3p0-style property '%2$s' have been set in Hibernate properties.  Hibernate-style property '%1$s' will be used and c3p0-style property '%2$s' will be ignored!", id=10001)
    public void bothHibernateAndC3p0StylesSet(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="C3P0 using driver: %s at URL: %s", id=10002)
    public void c3p0UsingDriver(String var1, String var2);

    @Message(value="JDBC Driver class not found: %s", id=10003)
    public String jdbcDriverNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not destroy C3P0 connection pool", id=10004)
    public void unableToDestroyC3p0ConnectionPool(@Cause SQLException var1);

    @Message(value="Could not instantiate C3P0 connection pool", id=10005)
    public String unableToInstantiateC3p0ConnectionPool();
}

