//$Id: Column.java 11282 2007-03-14 22:05:59Z epbernard $
//EJB3 Specification Copyright 2004-2006 Sun Microsystems, Inc.
package javax.persistence;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * Is used to specify a mapped column for a persistent property or field. If no Column annotation is
 * specified, the default values are applied.
 *
 * @author Emmanuel Bernard
 */
@Target({METHOD, FIELD}) @Retention(RUNTIME)
public @interface Column {
	/**
	 * The name of the column. Defaults to the property or field name
	 */
	String name() default "";
	/**
	 * Whether the property is a unique key. This is a shortcut for the UniqueConstraint
	 * annotation at the table level and is useful for when the unique key constraint is
	 * only a single field. This constraint applies in addition to any constraint entailed
	 * by primary key mapping and to constraints specified at the table level.
	 */
	boolean unique() default false;
	/**
	 * Whether the database column is nullable
	 */
	boolean nullable() default true;
	/**
	 * Whether the column is included in SQL INSERT statements generated by the persistence provider.
	 */
	boolean insertable() default true;
	/**
	 * Whether the column is included in SQL UPDATE statements generated by the persistence provider.
	 */
	boolean updatable() default true;
	/**
	 * The SQL fragment that is used when generating the DDL for the column.
	 * Defaults to the generated SQL to create a column of the inferred type.
	 */
	String columnDefinition() default "";
	/**
	 * The name of the table that contains the column. If absent the column is assumed to
	 * be in the primary table.
	 */
	String table() default "";
	/**
	 * The column length. (Applies only if a string-valued column is used.)
	 */
	int length() default 255;
	/**
	 * The precision for a decimal (exact numeric) column. (Applies only if a decimal column is used.)
	 * Value must be set by developer if used when generating the DDL for the column.
	 */
	int precision() default 0;
	/**
	 * The scale for a decimal (exact numeric) column. (Applies only if a decimal column is used.)
	 */
	int scale() default 0;
}
