/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.TypeInstantiationException;
import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.NativeImageOptions;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.word.WordTypes;

public abstract class SharedGraphBuilderPhase
extends GraphBuilderPhase.Instance {
    final WordTypes wordTypes;

    public SharedGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        this.wordTypes = wordTypes;
    }

    protected void run(StructuredGraph graph) {
        super.run(graph);
        assert (this.wordTypes == null || this.wordTypes.ensureGraphContainsNoWordTypeReferences(graph));
    }

    public static abstract class SharedBytecodeParser
    extends BytecodeParser {
        private final boolean explicitExceptionEdges;
        private final boolean allowIncompleteClassPath;

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            this(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges, NativeImageOptions.AllowIncompleteClasspath.getValue());
        }

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges, boolean allowIncompleteClasspath) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            this.explicitExceptionEdges = explicitExceptionEdges;
            this.allowIncompleteClassPath = allowIncompleteClasspath;
        }

        protected RuntimeException throwParserError(Throwable e) {
            if (e instanceof UserError.UserException) {
                throw (UserError.UserException)e;
            }
            throw super.throwParserError(e);
        }

        private WordTypes getWordTypes() {
            return ((SharedGraphBuilderPhase)this.getGraphBuilderInstance()).wordTypes;
        }

        private boolean checkWordTypes() {
            return this.getWordTypes() != null;
        }

        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.getSource().equals(Fold.class) || plugin.getSource().equals(Node.NodeIntrinsic.class);
        }

        protected JavaMethod lookupMethodInPool(int cpi, int opcode) {
            JavaMethod result = super.lookupMethodInPool(cpi, opcode);
            if (result == null) {
                throw VMError.shouldNotReachHere("Discovered an unresolved callee while parsing " + this.method.asStackTraceElement(this.bci()) + '.');
            }
            return result;
        }

        protected Object loadReferenceTypeLock() {
            return null;
        }

        protected void maybeEagerlyResolve(int cpi, int bytecode) {
            block2: {
                try {
                    super.maybeEagerlyResolve(cpi, bytecode);
                }
                catch (UnresolvedElementException e) {
                    if (e.getCause() instanceof LinkageError || e.getCause() instanceof IllegalAccessError) break block2;
                    throw e;
                }
            }
        }

        protected JavaType maybeEagerlyResolve(JavaType type, ResolvedJavaType accessingClass) {
            try {
                return super.maybeEagerlyResolve(type, accessingClass);
            }
            catch (LinkageError e) {
                return this.getMetaAccess().lookupJavaType(Object.class);
            }
        }

        protected void handleIllegalNewInstance(JavaType type) {
            if (!this.allowIncompleteClassPath) {
                String message = "Cannot instantiate " + type.toJavaName() + ". To diagnose the issue you can use the " + SharedBytecodeParser.allowIncompleteClassPathOption() + " option. The instantiation error is then reported at run time.";
                throw new TypeInstantiationException(message);
            }
            ExceptionSynthesizer.throwException((GraphBuilderContext)this, InstantiationError.class, type.toJavaName());
        }

        protected void handleUnresolvedNewInstance(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewObjectArray(JavaType type, ValueNode length) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewMultiArray(JavaType type, ValueNode[] dims) {
            this.handleUnresolvedType(type.getElementalType());
        }

        protected void handleUnresolvedInstanceOf(JavaType type, ValueNode object) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedCheckCast(JavaType type, ValueNode object) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedLoadConstant(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedExceptionType(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedStoreField(JavaField field, ValueNode value, ValueNode receiver) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedLoadField(JavaField field, ValueNode receiver) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedInvoke(JavaMethod javaMethod, CallTargetNode.InvokeKind invokeKind) {
            this.handleUnresolvedMethod(javaMethod);
        }

        private void handleUnresolvedType(JavaType type) {
            if (this.allowIncompleteClassPath) {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoClassDefFoundError.class, type.toJavaName());
            } else {
                SharedBytecodeParser.reportUnresolvedElement("type", type.toJavaName());
            }
        }

        private void handleUnresolvedField(JavaField field) {
            JavaType declaringClass = field.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.allowIncompleteClassPath) {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoSuchFieldError.class, field.format("%H.%n"));
            } else {
                SharedBytecodeParser.reportUnresolvedElement("field", field.format("%H.%n"));
            }
        }

        private void handleUnresolvedMethod(JavaMethod javaMethod) {
            JavaType declaringClass = javaMethod.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.allowIncompleteClassPath) {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoSuchMethodError.class, javaMethod.format("%H.%n(%P)"));
            } else {
                SharedBytecodeParser.reportUnresolvedElement("method", javaMethod.format("%H.%n(%P)"));
            }
        }

        private static void reportUnresolvedElement(String elementKind, String elementAsString) {
            String message = "Discovered unresolved " + elementKind + " during parsing: " + elementAsString + ". To diagnose the issue you can use the " + SharedBytecodeParser.allowIncompleteClassPathOption() + " option. The missing " + elementKind + " is then reported at run time when it is accessed the first time.";
            throw new UnresolvedElementException(message);
        }

        private static String allowIncompleteClassPathOption() {
            return SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+");
        }

        protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        }

        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        protected void genIf(ValueNode x, Condition cond, ValueNode y) {
            if (this.checkWordTypes() && (x.getStackKind() == JavaKind.Object && y.getStackKind() == this.getWordTypes().getWordKind() || x.getStackKind() == this.getWordTypes().getWordKind() && y.getStackKind() == JavaKind.Object)) {
                throw UserError.abort("Should not compare Word to Object in condition at %s in %s", this.method, this.method.asStackTraceElement(this.bci()));
            }
            super.genIf(x, cond, y);
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
            boolean isStatic = targetMethod.isStatic();
            if (!isStatic) {
                this.checkWordType(args[0], (JavaType)targetMethod.getDeclaringClass(), "call receiver");
            }
            for (int i = 0; i < targetMethod.getSignature().getParameterCount(false); ++i) {
                this.checkWordType(args[i + (isStatic ? 0 : 1)], targetMethod.getSignature().getParameterType(i, null), "call argument");
            }
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, profile, null);
        }

        protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
            this.checkWordType(returnVal, this.method.getSignature().getReturnType(null), "return value");
            super.genReturn(returnVal, returnKind);
        }

        private void checkWordType(ValueNode value, JavaType expectedType, String reason) {
            if (expectedType.getJavaKind() == JavaKind.Object && this.checkWordTypes()) {
                boolean isWordValue;
                boolean isWordTypeExpected = this.getWordTypes().isWord(expectedType);
                boolean bl = isWordValue = value.getStackKind() == this.getWordTypes().getWordKind();
                if (isWordTypeExpected && !isWordValue) {
                    throw UserError.abort("Expected Word but got Object for %s in %s", reason, this.method.asStackTraceElement(this.bci()));
                }
                if (!isWordTypeExpected && isWordValue) {
                    throw UserError.abort("Expected Object but got Word for %s in %s", reason, this.method.asStackTraceElement(this.bci()));
                }
            }
        }

        protected boolean needsExplicitNullCheckException(ValueNode object) {
            return this.needsExplicitException() && object.getStackKind() == JavaKind.Object;
        }

        protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
            return this.needsExplicitException() && value.getStackKind() == JavaKind.Object;
        }

        public boolean needsExplicitException() {
            return this.explicitExceptionEdges && !this.parsingIntrinsic();
        }

        public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
            return true;
        }

        protected static boolean isDeoptimizationEnabled() {
            return DeoptimizationSupport.enabled() && !SubstrateUtil.isBuildingLibgraal();
        }

        protected boolean isMethodDeoptTarget() {
            return this.method instanceof SharedMethod && ((SharedMethod)this.method).isDeoptTarget();
        }

        protected boolean asyncExceptionLiveness() {
            return SharedBytecodeParser.isDeoptimizationEnabled();
        }

        protected void clearNonLiveLocalsAtTargetCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || !(block instanceof BciBlockMapping.ExceptionDispatchBlock) || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtTargetCreation(block, state);
            }
        }

        protected void clearNonLiveLocalsAtLoopExitCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtLoopExitCreation(block, state);
            }
        }
    }
}

