/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.util.concurrent.ForkJoinPool;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public class LoomContinuationFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        if (JavaContinuations.useLoom()) {
            FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
            access.registerAsInHeap(StoredContinuation.class);
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ForkJoinPool.class, (String)"compensatedBlock", (Class[])new Class[]{ForkJoinPool.ManagedBlocker.class})});
        }
    }
}

