/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Objects;

public class NativeImageSystemIOWrappers {
    final CapturingStdioWrapper outWrapper = new CapturingStdioWrapper(System.out, new ByteArrayOutputStream(128));
    final CapturingStdioWrapper errWrapper = new CapturingStdioWrapper(System.err, new ByteArrayOutputStream(128));
    boolean useCapturing = false;

    NativeImageSystemIOWrappers() {
    }

    void verifySystemOutErrReplacement() {
        String format = "%s was changed during image building. This is not allowed.";
        UserError.guarantee(System.out == this.outWrapper, format, "System.out");
        UserError.guarantee(System.err == this.errWrapper, format, "System.err");
    }

    void flushCapturedContent() {
        this.outWrapper.flushCapturedContent();
        this.errWrapper.flushCapturedContent();
    }

    void replaceSystemOutErr() {
        System.setOut(this.outWrapper);
        System.setErr(this.errWrapper);
    }

    public static NativeImageSystemIOWrappers singleton() {
        return NativeImageSystemClassLoader.singleton().systemIOWrappers;
    }

    public PrintStream getOut() {
        return this.outWrapper.delegate;
    }

    public void setOut(PrintStream customOut) {
        this.outWrapper.delegate = Objects.requireNonNull(customOut);
    }

    public PrintStream getErr() {
        return this.errWrapper.delegate;
    }

    public void setErr(PrintStream customErr) {
        this.errWrapper.delegate = Objects.requireNonNull(customErr);
    }

    private final class CapturingStdioWrapper
    extends PrintStream {
        private final ByteArrayOutputStream buffer;
        private PrintStream delegate;

        private CapturingStdioWrapper(PrintStream delegate, ByteArrayOutputStream buffer) {
            super(buffer);
            this.buffer = buffer;
            this.delegate = delegate;
        }

        @Override
        public void write(int b) {
            if (NativeImageSystemIOWrappers.this.useCapturing) {
                super.write(b);
            } else {
                this.delegate.write(b);
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (NativeImageSystemIOWrappers.this.useCapturing) {
                super.write(buf, off, len);
            } else {
                this.delegate.write(buf, off, len);
            }
        }

        private void flushCapturedContent() {
            byte[] byteArray = this.buffer.toByteArray();
            this.delegate.write(byteArray, 0, byteArray.length);
            this.buffer.reset();
        }
    }
}

