/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.PredefinedClassesConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesRegistry;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

@AutomaticFeature
public class ClassPredefinitionFeature
implements Feature {
    private final Map<String, PredefinedClass> nameToRecord = new HashMap<String, PredefinedClass>();
    private boolean sealed = false;

    public void afterRegistration(Feature.AfterRegistrationAccess arg) {
        ImageSingletons.add(PredefinedClassesSupport.class, (Object)new PredefinedClassesSupport());
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)arg;
        PredefinedClassesRegistryImpl registry = new PredefinedClassesRegistryImpl();
        ImageSingletons.add(PredefinedClassesRegistry.class, (Object)registry);
        PredefinedClassesConfigurationParser parser = new PredefinedClassesConfigurationParser(registry, ConfigurationFiles.Options.StrictConfiguration.getValue());
        ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "class predefinition", ConfigurationFiles.Options.PredefinedClassesConfigurationFiles, ConfigurationFiles.Options.PredefinedClassesConfigurationResources, ConfigurationFile.PREDEFINED_CLASSES_NAME.getFileName());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.sealed = true;
        ArrayList skipped = new ArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        this.nameToRecord.forEach((name, record) -> {
            if (record.definedClass != null) {
                if (!record.definedClass.isAnnotation() && !record.definedClass.isEnum()) {
                    RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{record.definedClass});
                }
            } else if (record.pendingSubtypes != null) {
                StringBuilder msg = new StringBuilder();
                msg.append("Type ").append((String)name).append(" is neither on the classpath nor predefined and prevents the predefinition of these subtypes (and potentially their subtypes): ");
                boolean first = true;
                for (PredefinedClass superRecord : record.pendingSubtypes) {
                    msg.append(first ? "" : ", ").append(superRecord.name);
                    first = false;
                }
                errors.add(msg.toString());
            } else if (record.data == null) {
                skipped.add(record.name);
            }
        });
        if (!skipped.isEmpty()) {
            int limit = 10;
            String names = skipped.stream().limit(limit).collect(Collectors.joining(", "));
            if (skipped.size() > limit) {
                names = names + ", ...";
            }
            System.out.printf("Skipped %d predefined class(es) because the classpath already contains a class with the same name: %s%n", skipped.size(), names);
        }
        if (!errors.isEmpty()) {
            throw UserError.abort(errors);
        }
    }

    static final class PredefinedClass {
        final String name;
        Class<?> definedClass;
        List<PredefinedClass> pendingSubtypes;
        List<PredefinedClass> pendingSupertypes;
        String canonicalHash;
        byte[] data;
        List<String> aliasHashes;

        PredefinedClass(String name) {
            this.name = name;
        }

        void addAliasHash(String hash) {
            assert (this.definedClass == null) : "must not already be loaded";
            if (this.aliasHashes == null) {
                this.aliasHashes = new ArrayList<String>();
            }
            this.aliasHashes.add(hash);
        }

        void addPendingSubtype(PredefinedClass record) {
            assert (this.definedClass == null) : "must not already be loaded";
            if (this.pendingSubtypes == null) {
                this.pendingSubtypes = new ArrayList<PredefinedClass>();
            }
            this.pendingSubtypes.add(record);
        }

        public void addPendingSupertype(PredefinedClass record) {
            assert (this.definedClass == null) : "must not already be loaded";
            if (this.pendingSupertypes == null) {
                this.pendingSupertypes = new ArrayList<PredefinedClass>();
            }
            this.pendingSupertypes.add(record);
        }
    }

    private class PredefinedClassesRegistryImpl
    implements PredefinedClassesRegistry {
        private PredefinedClassesRegistryImpl() {
        }

        @Override
        public void add(String nameInfo, String providedHash, Path basePath) {
            if (!PredefinedClassesSupport.supportsBytecodes()) {
                throw UserError.abort("Cannot predefine class with hash %s from %s because class predefinition is disabled. Enable this feature using option %s.", providedHash, basePath, PredefinedClassesSupport.ENABLE_BYTECODES_OPTION);
            }
            UserError.guarantee(!ClassPredefinitionFeature.this.sealed, "Too late to add predefined classes. Registration must happen in a Feature before the analysis has started.", new Object[0]);
            try {
                Path path = basePath.resolve(providedHash + ".classdata");
                byte[] data = Files.readAllBytes(path);
                String hash = PredefinedClassesSupport.hash(data, 0, data.length);
                ClassReader reader = new ClassReader(data);
                ClassWriter writer = new ClassWriter(0);
                reader.accept(writer, 2);
                byte[] canonicalData = writer.toByteArray();
                String canonicalHash = PredefinedClassesSupport.hash(canonicalData, 0, canonicalData.length);
                String className = this.transformClassName(reader.getClassName());
                PredefinedClass record = ClassPredefinitionFeature.this.nameToRecord.computeIfAbsent(className, PredefinedClass::new);
                if (record.canonicalHash != null) {
                    if (!canonicalHash.equals(record.canonicalHash)) {
                        throw UserError.abort("More than one predefined class with the same name provided: " + className, new Object[0]);
                    }
                    if (record.definedClass != null) {
                        PredefinedClassesSupport.registerClass(hash, record.definedClass);
                    } else {
                        record.addAliasHash(hash);
                    }
                    return;
                }
                record.canonicalHash = canonicalHash;
                record.data = data;
                record.addAliasHash(hash);
                boolean pendingSupertypes = false;
                String superclassName = this.transformClassName(reader.getSuperName());
                if (NativeImageSystemClassLoader.singleton().forNameOrNull(superclassName, false) == null) {
                    this.addPendingSupertype(record, superclassName);
                    pendingSupertypes = true;
                }
                for (String intf : reader.getInterfaces()) {
                    String interfaceName = this.transformClassName(intf);
                    if (NativeImageSystemClassLoader.singleton().forNameOrNull(interfaceName, false) != null) continue;
                    this.addPendingSupertype(record, interfaceName);
                    pendingSupertypes = true;
                }
                if (!pendingSupertypes) {
                    this.defineClass(record);
                }
            }
            catch (IOException t) {
                throw UserError.abort(t, "Failed to prepare class with hash %s from %s for predefinition", providedHash, basePath);
            }
        }

        private void addPendingSupertype(PredefinedClass record, String superName) {
            PredefinedClass superRecord = ClassPredefinitionFeature.this.nameToRecord.computeIfAbsent(superName, PredefinedClass::new);
            assert (superRecord.definedClass == null) : "Must have been found with forName above";
            superRecord.addPendingSubtype(record);
            record.addPendingSupertype(superRecord);
        }

        private void defineClass(PredefinedClass record) {
            if (NativeImageSystemClassLoader.singleton().forNameOrNull(record.name, false) == null) {
                record.definedClass = NativeImageSystemClassLoader.singleton().predefineClass(record.name, record.data, 0, record.data.length);
                if (record.aliasHashes != null) {
                    for (String hash : record.aliasHashes) {
                        PredefinedClassesSupport.registerClass(hash, record.definedClass);
                    }
                }
            }
            record.data = null;
            record.aliasHashes = null;
            if (record.pendingSubtypes != null) {
                for (PredefinedClass subtype : record.pendingSubtypes) {
                    boolean removed = subtype.pendingSupertypes.remove(record);
                    assert (removed) : "must have been in list";
                    if (!subtype.pendingSupertypes.isEmpty()) continue;
                    record.pendingSupertypes = null;
                    this.defineClass(subtype);
                }
                record.pendingSubtypes = null;
            }
        }

        private String transformClassName(String className) {
            return className.replace('/', '.');
        }
    }
}

