/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributesView;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;

public class NativeImageResourceFileStore
extends FileStore {
    private final FileSystem resourceFileSystem;

    NativeImageResourceFileStore(Path path) {
        this.resourceFileSystem = path.getFileSystem();
    }

    @Override
    public String name() {
        return this.resourceFileSystem.toString() + this.resourceFileSystem.getSeparator();
    }

    @Override
    public String type() {
        return "rfs";
    }

    @Override
    public boolean isReadOnly() {
        return this.resourceFileSystem.isReadOnly();
    }

    @Override
    public long getTotalSpace() {
        throw new UnsupportedOperationException("This operation is not support for native image resource file system!");
    }

    @Override
    public long getUsableSpace() {
        throw new UnsupportedOperationException("This operation is not support for native image resource file system!");
    }

    @Override
    public long getUnallocatedSpace() {
        throw new UnsupportedOperationException("This operation is not support for native image resource file system!");
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return type == BasicFileAttributeView.class || type == NativeImageResourceFileAttributesView.class;
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return name.equals("basic") || name.equals("resource");
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("unallocatedSpace")) {
            return this.getUnallocatedSpace();
        }
        throw new UnsupportedOperationException("Attribute isn't supported!");
    }
}

