/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleOptions;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.TriState;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CompilationTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateTruffleRuntime
extends GraalTruffleRuntime {
    private static final int DEBUG_TEAR_DOWN_TIMEOUT = 2000;
    private static final int PRODUCTION_TEAR_DOWN_TIMEOUT = 10000;
    private GraalTruffleRuntime.CallMethods hostedCallMethods;
    private volatile BackgroundCompileQueue compileQueue;
    private volatile boolean initialized;
    private volatile Boolean profilingEnabled;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleRuntime() {
        super(Collections.emptyList());
        super.getLoopNodeFactory();
    }

    public BackgroundCompileQueue getCompileQueue() {
        return this.compileQueue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetHosted() {
        this.truffleCompiler = null;
    }

    private void initializeAtRuntime(OptimizedCallTarget callTarget) {
        this.truffleCompiler.initialize(SubstrateTruffleRuntime.getOptionsForCompiler((OptimizedCallTarget)callTarget), (CompilableTruffleAST)callTarget, true);
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            this.compileQueue = TruffleFeature.getSupport().createBackgroundCompileQueue(this);
        }
        if (callTarget.engine.traceTransferToInterpreter) {
            if (!SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
                Log.log().string("Warning: TraceTruffleTransferToInterpreter cannot print stack traces. Build image with -H:+IncludeNodeSourcePositions to enable stack traces.").newline();
            }
            RuntimeOptionValues.singleton().update(Deoptimizer.Options.TraceDeoptimization, true);
        }
        this.installDefaultListeners();
        RuntimeSupport.getRuntimeSupport().addTearDownHook(this::teardown);
    }

    private void teardown() {
        long timeout = SubstrateUtil.assertionsEnabled() ? 2000L : 10000L;
        this.getCompileQueue().shutdownAndAwaitTermination(timeout);
        TruffleCompiler tcp = this.truffleCompiler;
        if (tcp != null) {
            ((SubstrateTruffleCompiler)tcp).teardown();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler initTruffleCompiler() {
        assert (this.truffleCompiler == null) : "Cannot re-initialize Substrate TruffleCompiler";
        SubstrateTruffleCompiler compiler = this.newTruffleCompiler();
        this.truffleCompiler = compiler;
        return compiler;
    }

    public ResolvedJavaMethod[] getAnyFrameMethod() {
        return this.callMethods.anyFrameMethod;
    }

    protected String getCompilerConfigurationName() {
        TruffleCompiler compiler = this.truffleCompiler;
        if (compiler != null) {
            return compiler.getCompilerConfigurationName();
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler newTruffleCompiler() {
        return TruffleFeature.getSupport().createTruffleCompiler(this);
    }

    public SubstrateTruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        this.ensureInitializedAtRuntime((OptimizedCallTarget)compilable);
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void lookupCallMethods(MetaAccessProvider metaAccess) {
        super.lookupCallMethods(metaAccess);
        this.hostedCallMethods = GraalTruffleRuntime.CallMethods.lookup((MetaAccessProvider)GraalAccess.getOriginalProviders().getMetaAccess());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void clearState() {
        super.clearState();
        this.hostedCallMethods = null;
    }

    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (SubstrateUtil.HOSTED) {
            return this.hostedCallMethods;
        }
        return this.callMethods;
    }

    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.profilingEnabled == null) {
            this.profilingEnabled = SubstrateTruffleRuntime.getEngineData((RootNode)rootNode).profilingEnabled;
        }
        SubstrateOptimizedCallTarget callTarget = TruffleFeature.getSupport().createOptimizedCallTarget(source, rootNode);
        this.ensureInitializedAtRuntime(callTarget);
        return callTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitializedAtRuntime(OptimizedCallTarget callTarget) {
        if (!SubstrateUtil.HOSTED && !this.initialized) {
            SubstrateTruffleRuntime substrateTruffleRuntime = this;
            synchronized (substrateTruffleRuntime) {
                if (!this.initialized) {
                    this.initializeAtRuntime(callTarget);
                    this.initialized = true;
                }
            }
        }
    }

    public SpeculationLog createSpeculationLog() {
        return new SubstrateSpeculationLog();
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
    }

    public boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            this.profilingEnabled = SubstrateTruffleRuntime.getEngineData(null).profilingEnabled;
        }
        return this.profilingEnabled;
    }

    public CompilationTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        block5: {
            if (SubstrateUtil.HOSTED) {
                return null;
            }
            this.ensureInitializedAtRuntime(optimizedCallTarget);
            if (SubstrateTruffleOptions.isMultiThreaded()) {
                return super.submitForCompilation(optimizedCallTarget, lastTierCompilation);
            }
            try {
                this.doCompile(optimizedCallTarget, null);
            }
            catch (OptimizationFailedException e) {
                if (((Boolean)optimizedCallTarget.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsArePrinted)).booleanValue()) {
                    Log.log().string(this.printStackTraceToString(e));
                }
                if (!SubstrateTruffleOptions.TrufflePropagateCompilationErrors.getValue().booleanValue()) break block5;
                throw e;
            }
        }
        return null;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CompilationTask task, boolean mayBeAsynchronous) {
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            super.finishCompilation(optimizedCallTarget, task, mayBeAsynchronous);
        }
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        if (SubstrateTruffleOptions.isMultiThreaded()) {
            super.waitForCompilation(optimizedCallTarget, timeout);
            return;
        }
    }

    protected StackIntrospection getStackIntrospection() {
        return SubstrateStackIntrospection.SINGLETON;
    }

    public <T> T getGraalOptions(Class<T> type) {
        if (type == OptionValues.class) {
            return type.cast((Object)RuntimeOptionValues.singleton());
        }
        return (T)super.getGraalOptions(type);
    }

    protected boolean isPrintGraphEnabled() {
        return DebugOptions.PrintGraph.getValue(this.getGraalOptions(OptionValues.class)) != DebugOptions.PrintGraphTarget.Disable;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetNativeImageState() {
        this.clearState();
    }

    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        return (T)KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject(type, constant), Object.class);
    }

    protected JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject(object);
    }

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        return TruffleFeature.getSupport().registerOptimizedAssumptionDependency(optimizedAssumptionConstant);
    }

    public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        return TruffleFeature.getSupport().getCallTargetForCallNode(callNodeConstant);
    }

    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return TruffleFeature.getSupport().asCompilableTruffleAST(constant);
    }

    public void log(String loggerId, CompilableTruffleAST compilable, String message) {
        if (!TruffleFeature.getSupport().tryLog(this, loggerId, compilable, message)) {
            super.log(loggerId, compilable, message);
        }
    }

    public boolean isSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
        TriState res = TruffleFeature.getSupport().tryIsSuppressedFailure(compilable, serializedException);
        switch (res) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case UNDEFINED: {
                return super.isSuppressedFailure(compilable, serializedException);
            }
        }
        throw new IllegalStateException("Unsupported value " + res);
    }
}

