/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.phases.NoClassInitializationPlugin;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class LambdaProxyRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private final BigBang bb;
    private final ConcurrentHashMap<ResolvedJavaType, LambdaSubstitutionType> typeSubstitutions = new ConcurrentHashMap();
    private final Set<String> uniqueLambdaProxyNames = new HashSet<String>();

    LambdaProxyRenamingSubstitutionProcessor(BigBang bigBang) {
        this.bb = bigBang;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (LambdaUtils.isLambdaType((ResolvedJavaType)type)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof LambdaSubstitutionType) {
            return ((LambdaSubstitutionType)type).getOriginal();
        }
        return type;
    }

    private LambdaSubstitutionType getSubstitution(ResolvedJavaType original) {
        return this.typeSubstitutions.computeIfAbsent(original, key -> {
            OptionValues options = this.bb.getOptions();
            DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getProviders().getSnippetReflection())).build();
            Providers providers = GraalAccess.getOriginalProviders();
            String lambdaTargetName = LambdaUtils.findStableLambdaName((ClassInitializationPlugin)new NoClassInitializationPlugin(), (Providers)providers, (ResolvedJavaType)key, (OptionValues)options, (DebugContext)debug, (Object)((Object)this));
            return new LambdaSubstitutionType((ResolvedJavaType)key, this.findUniqueLambdaProxyName(lambdaTargetName));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueLambdaProxyName(String lambdaTargetName) {
        Set<String> set = this.uniqueLambdaProxyNames;
        synchronized (set) {
            String newStableName = lambdaTargetName;
            CharSequence stableNameBase = lambdaTargetName.subSequence(0, lambdaTargetName.length() - 1);
            int i = 1;
            while (this.uniqueLambdaProxyNames.contains(newStableName)) {
                newStableName = stableNameBase + "_" + i + ";";
                ++i;
            }
            this.uniqueLambdaProxyNames.add(newStableName);
            return newStableName;
        }
    }
}

