/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.code.CompilationResult;

class SingleInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64Assembler.SingleInstructionAnnotation annotation;

    SingleInstructionHostedPatcher(AArch64Assembler.SingleInstructionAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        throw VMError.shouldNotReachHere("Currently relocations must use either adrp/ldp, adrp/add, or a sequence of moves");
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int codePos, int relative, byte[] code) {
        this.annotation.patch(codePos, relative, code);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

