/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOf;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfNode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class SubstrateArraysCopyOfWithExceptionNode
extends WithExceptionNode
implements SubstrateArraysCopyOf,
DeoptimizingNode.DeoptBefore,
SingleMemoryKill {
    public static final NodeClass<SubstrateArraysCopyOfWithExceptionNode> TYPE = NodeClass.create(SubstrateArraysCopyOfWithExceptionNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;
    @Node.Input
    ValueNode original;
    @Node.Input
    ValueNode originalLength;
    @Node.Input
    ValueNode newLength;
    @Node.Input
    ValueNode newArrayType;
    int bci;

    public SubstrateArraysCopyOfWithExceptionNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode original, ValueNode originaLength, ValueNode newLength, ValueNode newArrayType, int bci) {
        super(TYPE, SubstrateArraysCopyOf.computeStamp(stamp));
        this.original = original;
        this.originalLength = originaLength;
        this.newLength = newLength;
        this.newArrayType = newArrayType;
        this.bci = bci;
    }

    @Override
    public ValueNode getOriginal() {
        return this.original;
    }

    @Override
    public ValueNode getOriginalLength() {
        return this.originalLength;
    }

    @Override
    public ValueNode getNewArrayType() {
        return this.newArrayType;
    }

    @Override
    public ValueNode getNewLength() {
        return this.newLength;
    }

    public boolean canDeoptimize() {
        return true;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public void setStateBefore(FrameState state) {
        this.updateUsages((Node)this.stateBefore, (Node)state);
        this.stateBefore = state;
    }

    int bci() {
        return this.bci;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FixedNode replaceWithNonThrowing() {
        SubstrateArraysCopyOfNode plainArrayCopy = (SubstrateArraysCopyOfNode)this.asNode().graph().add((Node)new SubstrateArraysCopyOfNode(this.stamp, this.getOriginal(), this.getOriginalLength(), this.getNewLength(), this.getNewArrayType()));
        plainArrayCopy.setStateBefore(this.stateBefore());
        AbstractBeginNode oldException = this.exceptionEdge();
        this.graph().replaceSplitWithFixed((ControlSplitNode)this, (FixedWithNextNode)plainArrayCopy, this.next());
        GraphUtil.killCFG((FixedNode)oldException);
        return plainArrayCopy;
    }
}

