/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.image.AbstractBootImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.options.Option;

public abstract class CCLinkerInvocation
implements LinkerInvocation {
    protected final List<String> additionalPreOptions = new ArrayList<String>();
    private String compilerCommand = "cc";
    protected final List<String> inputFilenames = new ArrayList<String>();
    protected final List<String> rpaths = new ArrayList<String>();
    protected final List<String> libpaths = new ArrayList<String>();
    protected final List<String> libs = new ArrayList<String>();
    protected Path outputFile;
    protected AbstractBootImage.NativeImageKind outputKind;

    @Override
    public List<String> getInputFiles() {
        return Collections.unmodifiableList(this.inputFilenames);
    }

    @Override
    public void addInputFile(String filename) {
        this.inputFilenames.add(filename);
    }

    @Override
    public void addInputFile(int index, String filename) {
        this.inputFilenames.add(index, filename);
    }

    public AbstractBootImage.NativeImageKind getOutputKind() {
        return this.outputKind;
    }

    public void setOutputKind(AbstractBootImage.NativeImageKind k) {
        this.outputKind = k;
    }

    @Override
    public List<String> getLibPaths() {
        return Collections.unmodifiableList(this.libpaths);
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(this.libpaths.size(), libPath);
    }

    @Override
    public void addLibPath(int index, String libPath) {
        if (!libPath.isEmpty()) {
            this.libpaths.add(index, libPath);
        }
    }

    @Override
    public List<String> getRPaths() {
        return Collections.unmodifiableList(this.rpaths);
    }

    @Override
    public void addRPath(String rPath) {
        this.addRPath(this.rpaths.size(), rPath);
    }

    @Override
    public void addRPath(int index, String rPath) {
        if (!rPath.isEmpty()) {
            this.rpaths.add(rPath);
        }
    }

    @Override
    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(Path out) {
        this.outputFile = out;
    }

    @Override
    public List<String> getLinkedLibraries() {
        return Collections.unmodifiableList(this.libs);
    }

    @Override
    public void addLinkedLibrary(String libname) {
        this.libs.add(libname);
    }

    @Override
    public void addLinkedLibrary(int index, String libname) {
        this.libs.add(index, libname);
    }

    @Override
    public String getCompilerCommand() {
        String customCompiler = CCompilerInvoker.getCCompilerPath();
        if (customCompiler != null) {
            return customCompiler;
        }
        return this.compilerCommand;
    }

    @Override
    public void setCompilerCommand(String command) {
        this.compilerCommand = command;
    }

    protected abstract void setOutputKind(List<String> var1);

    @Override
    public List<String> getCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getCompilerCommand());
        cmd.add("-v");
        cmd.add("-o");
        cmd.add(this.outputFile.toString());
        for (String opt : this.additionalPreOptions) {
            cmd.add(opt);
        }
        this.setOutputKind(cmd);
        for (String libpath : this.libpaths) {
            cmd.add("-L" + libpath);
        }
        for (String rpath : this.rpaths) {
            cmd.add("-Wl,-rpath");
            cmd.add("-Wl," + rpath);
        }
        cmd.addAll(this.inputFilenames);
        for (String lib : this.libs) {
            if (lib.startsWith("-")) {
                cmd.add("-Wl," + lib.replace(" ", ","));
                continue;
            }
            cmd.add("-l" + lib);
        }
        for (String nativeLinkerOption : Options.NativeLinkerOption.getValue()) {
            cmd.add(nativeLinkerOption);
        }
        return cmd;
    }

    @Override
    public void addAdditionalPreOption(String option) {
        this.additionalPreOptions.add(option);
    }

    public static class Options {
        @Option(help={"Pass the provided raw option to the linker command that produces the final binary. The possible options are platform specific and passed through without any validation."})
        public static final HostedOptionKey<String[]> NativeLinkerOption = new HostedOptionKey<String[]>(new String[0]);
    }
}

