/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class VMError {
    public static RuntimeException shouldNotReachHere() {
        throw new HostedError("should not reach here");
    }

    public static RuntimeException shouldNotReachHere(String msg) {
        throw new HostedError(msg);
    }

    public static RuntimeException shouldNotReachHere(Throwable ex) {
        throw new HostedError(ex);
    }

    public static RuntimeException shouldNotReachHere(String msg, Throwable cause) {
        throw new HostedError(msg, cause);
    }

    public static void guarantee(boolean condition) {
        if (!condition) {
            throw new HostedError("guarantee failed");
        }
    }

    public static void guarantee(boolean condition, String msg) {
        if (!condition) {
            throw new HostedError(msg);
        }
    }

    public static RuntimeException unimplemented() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public static RuntimeException unsupportedFeature(String msg) {
        throw new HostedError("UNSUPPORTED FEATURE: " + msg);
    }

    public static boolean hostedError(Throwable t) {
        return t instanceof HostedError;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class HostedError
    extends Error {
        private static final long serialVersionUID = 1574347086891451263L;

        HostedError(String msg) {
            super(msg);
        }

        HostedError(Throwable ex) {
            super(ex);
        }

        HostedError(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

