/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.DetachedParkEvent;
import com.oracle.svm.core.thread.ParkEventConsCell;
import com.oracle.svm.core.thread.ParkEventList;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class ParkEvent {
    protected boolean event;
    protected boolean resetEventBeforeWait;
    private ParkEventConsCell consCell;

    protected ParkEvent() {
    }

    protected abstract WaitResult condWait();

    protected abstract WaitResult condTimedWait(long var1);

    protected abstract void unpark();

    ParkEventConsCell consumeConsCell() {
        assert (this.consCell != null) : "Consuming null cons cell.";
        ParkEventConsCell result = this.consCell;
        this.consCell = null;
        return result;
    }

    static ParkEvent initializeOnce(UninterruptibleUtils.AtomicReference<ParkEvent> ref, boolean resetEventBeforeWait) {
        ParkEvent result = ref.get();
        if (result == null) {
            ParkEvent newEvent = ParkEvent.acquire();
            newEvent.consCell = new ParkEventConsCell(newEvent);
            newEvent.event = false;
            newEvent.resetEventBeforeWait = resetEventBeforeWait;
            if (ref.compareAndSet(null, newEvent)) {
                result = newEvent;
            } else {
                ParkEvent.release(newEvent);
                result = ref.get();
                VMError.guarantee(result != null, "ParkEvent must never be reset to null once it has been initialized.");
            }
        }
        return result;
    }

    private static ParkEvent acquire() {
        ParkEvent result = ParkEventList.getSingleton().pop();
        if (result == null) {
            result = ((ParkEventFactory)ImageSingletons.lookup(ParkEventFactory.class)).create();
        }
        return result;
    }

    static void detach(UninterruptibleUtils.AtomicReference<ParkEvent> ref) {
        ParkEvent event = ref.getAndSet(DetachedParkEvent.SINGLETON);
        if (event != null && event != DetachedParkEvent.SINGLETON) {
            ParkEvent.release(event);
        }
    }

    private static void release(ParkEvent event) {
        ParkEventList.getSingleton().push(event);
    }

    public static enum WaitResult {
        UNPARKED,
        TIMED_OUT,
        INTERRUPTED;

    }

    public static interface ParkEventFactory {
        public ParkEvent create();
    }
}

