/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.JavaUtilZipSubstitutions;
import com.oracle.svm.core.posix.Util_java_util_zip_Inflater;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
@TargetClass(value=Inflater.class)
final class Target_java_util_zip_Inflater {
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private byte[] buf;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int off;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int len;
    @Alias
    private boolean finished;
    @Alias
    private boolean needDict;

    Target_java_util_zip_Inflater() {
    }

    @Substitute
    private static long init(boolean nowrap) {
        ZLib.z_stream strm = (ZLib.z_stream)LibC.calloc(WordFactory.unsigned((int)1), SizeOf.unsigned(ZLib.z_stream.class));
        if (strm.isNull()) {
            throw new OutOfMemoryError();
        }
        int ret = ZLib.inflateInit2(strm, nowrap ? -ZLib.MAX_WBITS() : ZLib.MAX_WBITS());
        if (ret == ZLib.Z_OK()) {
            return strm.rawValue();
        }
        LibC.free(strm);
        if (ret == ZLib.Z_MEM_ERROR()) {
            throw new OutOfMemoryError();
        }
        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
    }

    @Substitute
    private static void setDictionary(long addr, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            CCharPointer bytes = (CCharPointer)pinned.addressOfArrayElement(off);
            JavaUtilZipSubstitutions.Util_java_util_zip_Inflater.doSetDictionary(addr, bytes, len);
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private int inflateBytes(long addr, byte[] b, int off, int len) throws DataFormatException {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        Throwable throwable = null;
        try (PinnedObject pinnedInBuf = PinnedObject.create((Object)this.buf);){
            int ret;
            Throwable throwable2;
            PinnedObject pinnedOutBuf;
            block54: {
                int n;
                block55: {
                    block56: {
                        block51: {
                            int n2;
                            block52: {
                                block53: {
                                    block48: {
                                        int n3;
                                        block49: {
                                            block50: {
                                                block45: {
                                                    int n4;
                                                    block46: {
                                                        block47: {
                                                            pinnedOutBuf = PinnedObject.create((Object)b);
                                                            throwable2 = null;
                                                            strm.set_next_in((CCharPointer)pinnedInBuf.addressOfArrayElement(this.off));
                                                            strm.set_next_out((CCharPointer)pinnedOutBuf.addressOfArrayElement(off));
                                                            strm.set_avail_in(this.len);
                                                            strm.set_avail_out(len);
                                                            ret = ZLib.inflate(strm, ZLib.Z_PARTIAL_FLUSH());
                                                            if (ret != ZLib.Z_STREAM_END()) break block45;
                                                            this.finished = true;
                                                            n4 = Util_java_util_zip_Inflater.update(this, len, strm);
                                                            if (pinnedOutBuf == null) break block46;
                                                            if (throwable2 == null) break block47;
                                                            try {
                                                                pinnedOutBuf.close();
                                                            }
                                                            catch (Throwable throwable3) {
                                                                throwable2.addSuppressed(throwable3);
                                                            }
                                                            break block46;
                                                        }
                                                        pinnedOutBuf.close();
                                                    }
                                                    return n4;
                                                }
                                                if (ret != ZLib.Z_OK()) break block48;
                                                n3 = Util_java_util_zip_Inflater.update(this, len, strm);
                                                if (pinnedOutBuf == null) break block49;
                                                if (throwable2 == null) break block50;
                                                try {
                                                    pinnedOutBuf.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                                break block49;
                                            }
                                            pinnedOutBuf.close();
                                        }
                                        return n3;
                                    }
                                    if (ret != ZLib.Z_NEED_DICT()) break block51;
                                    this.needDict = true;
                                    Util_java_util_zip_Inflater.update(this, len, strm);
                                    n2 = 0;
                                    if (pinnedOutBuf == null) break block52;
                                    if (throwable2 == null) break block53;
                                    try {
                                        pinnedOutBuf.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    break block52;
                                }
                                pinnedOutBuf.close();
                            }
                            return n2;
                        }
                        if (ret != ZLib.Z_BUF_ERROR()) break block54;
                        n = 0;
                        if (pinnedOutBuf == null) break block55;
                        if (throwable2 == null) break block56;
                        try {
                            pinnedOutBuf.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        break block55;
                    }
                    pinnedOutBuf.close();
                }
                return n;
            }
            try {
                try {
                    try {
                        if (ret == ZLib.Z_DATA_ERROR()) {
                            throw new DataFormatException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
                        }
                        if (ret == ZLib.Z_MEM_ERROR()) {
                            throw new OutOfMemoryError();
                        }
                        throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                }
                catch (Throwable throwable8) {
                    if (pinnedOutBuf != null) {
                        if (throwable2 != null) {
                            try {
                                pinnedOutBuf.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            pinnedOutBuf.close();
                        }
                    }
                    throw throwable8;
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
        }
    }

    @Substitute
    private static int getAdler(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        return (int)strm.adler().rawValue();
    }

    @Substitute
    private static void reset(long addr) {
        if (ZLib.inflateReset((ZLib.z_stream)WordFactory.pointer((long)addr)) != ZLib.Z_OK()) {
            throw new InternalError();
        }
    }

    @Substitute
    private static void end(long addr) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        if (ZLib.inflateEnd(strm) == ZLib.Z_STREAM_ERROR()) {
            throw new InternalError();
        }
        LibC.free(strm);
    }
}

