/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import java.util.ArrayList;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GCCause {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final ArrayList<GCCause> HostedGCCauseList = new ArrayList();
    public static final GCCause JavaLangSystemGC = new GCCause("java.lang.System.gc()");
    public static final GCCause UnitTest = new GCCause("UnitTest");
    public static final GCCause TestGCInDeoptimizer = new GCCause("TestGCInDeoptimizer");
    protected static GCCause[] GCCauses = new GCCause[]{JavaLangSystemGC, UnitTest, TestGCInDeoptimizer};
    private final int id;
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCCause(String name) {
        ArrayList<GCCause> arrayList = HostedGCCauseList;
        synchronized (arrayList) {
            this.id = HostedGCCauseList.size();
            this.name = name;
            HostedGCCauseList.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static GCCause fromId(int causeId) {
        return GCCauses[causeId];
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void cacheReverseMapping() {
        GCCauses = HostedGCCauseList.toArray(new GCCause[HostedGCCauseList.size()]);
    }
}

