/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ErrorDialog {
    static /* synthetic */ Class class$javax$swing$JDialog;

    private ErrorDialog() {
    }

    public static void showErrorDialog(Component source, Object message, final Throwable detail) {
        final JButton details = new JButton("Details...");
        details.setEnabled(detail != null);
        details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog owner = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ErrorDialog.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, details);
                ErrorDetailsDialog dlg = new ErrorDetailsDialog(owner, detail);
                dlg.setDefaultCloseOperation(2);
                dlg.pack();
                dlg.setLocationRelativeTo(owner);
                dlg.setVisible(true);
            }
        });
        if (source != null) {
            source.getToolkit().beep();
        }
        Object[] options = new Object[]{"OK", details};
        JOptionPane.showOptionDialog(source, message, "Error...", -1, 0, null, options, options[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ErrorDetailsDialog
    extends JDialog {
        public ErrorDetailsDialog(JDialog owner, Throwable detail) {
            super(owner);
            JComponent messageComponent = null;
            JTabbedPane tabs = null;
            for (Throwable ex = detail; ex != null; ex = ex.getCause()) {
                JTextArea ta = new JTextArea();
                ta.append(ex + "\n");
                StackTraceElement[] trace = ex.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    ta.append("    at " + trace[i] + "\n");
                }
                JScrollPane scroll = new JScrollPane(ta);
                ta.setCaretPosition(0);
                ta.setEditable(false);
                scroll.setPreferredSize(new Dimension(400, 300));
                if (ex != null) {
                    if (messageComponent == null) {
                        tabs = new JTabbedPane();
                        messageComponent = tabs;
                        tabs.addTab("Exception", scroll);
                        continue;
                    }
                    tabs.addTab("Caused by", scroll);
                    continue;
                }
                if (messageComponent == null) {
                    messageComponent = scroll;
                    break;
                }
                tabs.addTab("Caused by", scroll);
                break;
            }
            this.getContentPane().add(messageComponent);
            JButton close = new JButton("Close"){

                public void fireActionPerformed(ActionEvent event) {
                    ErrorDetailsDialog.this.dispose();
                }
            };
            JPanel panel = new JPanel();
            panel.add(close);
            this.getContentPane().add((Component)panel, "South");
        }
    }
}

