/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBBigDecimalField;
import org.firebirdsql.jdbc.field.FBBlobField;
import org.firebirdsql.jdbc.field.FBCachedBlobField;
import org.firebirdsql.jdbc.field.FBCachedLongVarCharField;
import org.firebirdsql.jdbc.field.FBDateField;
import org.firebirdsql.jdbc.field.FBDoubleField;
import org.firebirdsql.jdbc.field.FBFloatField;
import org.firebirdsql.jdbc.field.FBIntegerField;
import org.firebirdsql.jdbc.field.FBLongField;
import org.firebirdsql.jdbc.field.FBLongVarCharField;
import org.firebirdsql.jdbc.field.FBShortField;
import org.firebirdsql.jdbc.field.FBTimeField;
import org.firebirdsql.jdbc.field.FBTimestampField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TranslatingReader;
import org.firebirdsql.jdbc.field.TypeConvertionException;

public abstract class FBField {
    static String BYTE_CONVERSION_ERROR = "Error converting to byte.";
    static String SHORT_CONVERSION_ERROR = "Error converting to short.";
    static String INT_CONVERSION_ERROR = "Error converting to int.";
    static String LONG_CONVERSION_ERROR = "Error converting to long.";
    static String FLOAT_CONVERSION_ERROR = "Error converting to float.";
    static String DOUBLE_CONVERSION_ERROR = "Error converting to double.";
    static String BIGDECIMAL_CONVERSION_ERROR = "Error converting to big decimal.";
    static String BOOLEAN_CONVERSION_ERROR = "Error converting to boolean.";
    static String STRING_CONVERSION_ERROR = "Error converting to string.";
    static String OBJECT_CONVERSION_ERROR = "Error converting to object.";
    static String DATE_CONVERSION_ERROR = "Error converting to date.";
    static String TIME_CONVERSION_ERROR = "Error converting to time.";
    static String TIMESTAMP_CONVERSION_ERROR = "Error converting to timestamp.";
    static String ASCII_STREAM_CONVERSION_ERROR = "Error converting to ascii stream.";
    static String UNICODE_STREAM_CONVERSION_ERROR = "Error converting to unicode stream.";
    static String BINARY_STREAM_CONVERSION_ERROR = "Error converting to binary stream.";
    static String CHARACTER_STREAM_CONVERSION_ERROR = "Error converting to character stream.";
    static String BYTES_CONVERSION_ERROR = "Error converting to array of bytes.";
    static String BLOB_CONVERSION_ERROR = "Error converting to Firebird BLOB object";
    static String SQL_TYPE_NOT_SUPPORTED = "SQL type for this field is not yet supported.";
    static String SQL_ARRAY_NOT_SUPPORTED = "Types.ARRAY: " + SQL_TYPE_NOT_SUPPORTED;
    static final byte BYTE_NULL_VALUE = 0;
    static final short SHORT_NULL_VALUE = 0;
    static final int INT_NULL_VALUE = 0;
    static final long LONG_NULL_VALUE = 0L;
    static final float FLOAT_NULL_VALUE = 0.0f;
    static final double DOUBLE_NULL_VALUE = 0.0;
    static final BigDecimal BIGDECIMAL_NULL_VALUE = null;
    static final String STRING_NULL_VALUE = null;
    static final Object OBJECT_NULL_VALUE = null;
    static final boolean BOOLEAN_NULL_VALUE = false;
    static final Date DATE_NULL_VALUE = null;
    static final Time TIME_NULL_VALUE = null;
    static final Timestamp TIMESTAMP_NULL_VALUE = null;
    static final InputStream STREAM_NULL_VALUE = null;
    static final Reader READER_NULL_VALUE = null;
    static final byte[] BYTES_NULL_VALUE = null;
    static final FBBlob BLOB_NULL_VALUE = null;
    static final byte MAX_BYTE_VALUE = 127;
    static final byte MIN_BYTE_VALUE = -128;
    static final short MAX_SHORT_VALUE = Short.MAX_VALUE;
    static final short MIN_SHORT_VALUE = Short.MIN_VALUE;
    static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    static final int MIN_INT_VALUE = Integer.MIN_VALUE;
    static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    static final long MIN_LONG_VALUE = Long.MIN_VALUE;
    static final float MAX_FLOAT_VALUE = Float.MAX_VALUE;
    static final float MIN_FLOAT_VALUE = -3.4028235E38f;
    static final double MAX_DOUBLE_VALUE = Double.MAX_VALUE;
    static final double MIN_DOUBLE_VALUE = -1.7976931348623157E308;
    protected XSQLVAR field;
    private FieldDataProvider dataProvider;
    protected int numCol;
    protected GDSHelper gdsHelper = null;
    protected String iscEncoding = null;
    protected String javaEncoding = null;
    protected String mappingPath = null;
    protected int requiredType;
    protected int scale = -1;

    FBField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        if (field == null) {
            throw new FBSQLException("Cannot create FBField instance for null as XSQLVAR.", "HY009");
        }
        this.field = field;
        this.dataProvider = dataProvider;
        this.requiredType = requiredType;
    }

    protected byte[] getFieldData() {
        return this.dataProvider.getFieldData();
    }

    protected void setFieldData(byte[] data) {
        this.dataProvider.setFieldData(data);
    }

    static Throwable createException(String message) {
        return new TypeConvertionException(message);
    }

    public boolean isNull() throws SQLException {
        return this.dataProvider.getFieldData() == null;
    }

    public void setNull() {
        this.setFieldData(null);
    }

    public void setConnection(GDSHelper gdsHelper) {
        this.gdsHelper = gdsHelper;
        if (gdsHelper != null) {
            this.iscEncoding = gdsHelper.getIscEncoding();
        }
        if (this.iscEncoding != null && (this.iscEncoding.equalsIgnoreCase("NONE") || this.iscEncoding.equalsIgnoreCase("BINARY"))) {
            this.iscEncoding = null;
        }
        if (gdsHelper != null) {
            this.javaEncoding = gdsHelper.getJavaEncoding();
            this.mappingPath = gdsHelper.getMappingPath();
        }
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
    }

    public static final boolean isType(XSQLVAR field, int type) {
        int tempType = field.sqltype & 0xFFFFFFFE;
        switch (tempType) {
            case 540: {
                return type == 2003;
            }
            case 520: {
                if (field.sqlsubtype < 0) {
                    return type == 2004;
                }
                if (field.sqlsubtype == 1) {
                    return type == -1;
                }
                return type == -4 || type == -3 || type == -2;
            }
            case 530: {
                return false;
            }
            case 480: {
                return type == 8;
            }
            case 482: {
                return type == 6;
            }
            case 580: {
                return type == -5;
            }
            case 496: {
                return type == 4;
            }
            case 550: {
                return false;
            }
            case 500: {
                return type == 5;
            }
            case 452: {
                return type == 1;
            }
            case 510: {
                return type == 93;
            }
            case 570: {
                return type == 91;
            }
            case 560: {
                return type == 92;
            }
            case 448: {
                return type == 12;
            }
        }
        return false;
    }

    public static final boolean isCompatible(XSQLVAR field, int type) {
        int tempType = field.sqltype & 0xFFFFFFFE;
        switch (tempType) {
            case 540: {
                return type == 2003;
            }
            case 520: {
                return type == 2004 || type == -2 || type == -3 || type == -4 || type == -1;
            }
            case 530: 
            case 550: {
                return false;
            }
            case 480: 
            case 482: 
            case 496: 
            case 500: 
            case 580: {
                return type == 8 || type == 6 || type == 7 || type == -5 || type == 4 || type == 5 || type == -6 || type == 2 || type == 3 || type == -7;
            }
            case 448: 
            case 452: {
                return type == 1 || type == 12 || type == -1;
            }
            case 510: {
                return type == 93 || type == 92 || type == 91;
            }
            case 570: {
                return type == 91 || type == 93;
            }
            case 560: {
                return type == 92 || type == 93;
            }
        }
        return false;
    }

    public static final FBField createField(XSQLVAR field, FieldDataProvider dataProvider, GDSHelper gdsHelper, boolean cached) throws SQLException {
        FBField result = FBField.createField(field, dataProvider, cached);
        result.setConnection(gdsHelper);
        return result;
    }

    private static FBField createField(XSQLVAR field, FieldDataProvider dataProvider, boolean cached) throws SQLException {
        if (FBField.isType(field, 5)) {
            if (field.sqlscale == 0) {
                return new FBShortField(field, dataProvider, 5);
            }
            return new FBBigDecimalField(field, dataProvider, 1, 2);
        }
        if (FBField.isType(field, 4)) {
            if (field.sqlscale == 0) {
                return new FBIntegerField(field, dataProvider, 4);
            }
            return new FBBigDecimalField(field, dataProvider, 2, 2);
        }
        if (FBField.isType(field, -5)) {
            if (field.sqlscale == 0) {
                return new FBLongField(field, dataProvider, -5);
            }
            return new FBBigDecimalField(field, dataProvider, 3, 2);
        }
        if (FBField.isType(field, 6)) {
            return new FBFloatField(field, dataProvider, 6);
        }
        if (FBField.isType(field, 8)) {
            return new FBDoubleField(field, dataProvider, 8);
        }
        if (FBField.isType(field, 1)) {
            return new FBWorkaroundStringField(field, dataProvider, 1);
        }
        if (FBField.isType(field, 12)) {
            return new FBWorkaroundStringField(field, dataProvider, 12);
        }
        if (FBField.isType(field, 91)) {
            return new FBDateField(field, dataProvider, 91);
        }
        if (FBField.isType(field, 92)) {
            return new FBTimeField(field, dataProvider, 92);
        }
        if (FBField.isType(field, 93)) {
            return new FBTimestampField(field, dataProvider, 93);
        }
        if (FBField.isType(field, 2004)) {
            if (cached) {
                return new FBCachedBlobField(field, dataProvider, 2004);
            }
            return new FBBlobField(field, dataProvider, 2004);
        }
        if (FBField.isType(field, -4)) {
            if (cached) {
                return new FBCachedBlobField(field, dataProvider, -4);
            }
            return new FBBlobField(field, dataProvider, -4);
        }
        if (FBField.isType(field, -1)) {
            if (cached) {
                return new FBCachedLongVarCharField(field, dataProvider, -1);
            }
            return new FBLongVarCharField(field, dataProvider, -1);
        }
        if (FBField.isType(field, 2003)) {
            throw (SQLException)FBField.createException(SQL_ARRAY_NOT_SUPPORTED);
        }
        throw (SQLException)FBField.createException(SQL_TYPE_NOT_SUPPORTED);
    }

    public String getName() {
        return this.field.sqlname;
    }

    public String getAlias() {
        return this.field.aliasname;
    }

    public String getRelationName() {
        return this.field.relname;
    }

    public void close() throws SQLException {
    }

    public byte getByte() throws SQLException {
        throw (SQLException)FBField.createException(BYTE_CONVERSION_ERROR).fillInStackTrace();
    }

    public short getShort() throws SQLException {
        throw (SQLException)FBField.createException(SHORT_CONVERSION_ERROR).fillInStackTrace();
    }

    public int getInt() throws SQLException {
        throw (SQLException)FBField.createException(INT_CONVERSION_ERROR).fillInStackTrace();
    }

    public long getLong() throws SQLException {
        throw (SQLException)FBField.createException(LONG_CONVERSION_ERROR).fillInStackTrace();
    }

    public float getFloat() throws SQLException {
        throw (SQLException)FBField.createException(FLOAT_CONVERSION_ERROR).fillInStackTrace();
    }

    public double getDouble() throws SQLException {
        throw (SQLException)FBField.createException(DOUBLE_CONVERSION_ERROR).fillInStackTrace();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw (SQLException)FBField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        return this.getBigDecimal();
    }

    public boolean getBoolean() throws SQLException {
        throw (SQLException)FBField.createException(BOOLEAN_CONVERSION_ERROR).fillInStackTrace();
    }

    public String getString() throws SQLException {
        throw (SQLException)FBField.createException(STRING_CONVERSION_ERROR).fillInStackTrace();
    }

    private boolean isOctetsAsBytes() {
        if (this.gdsHelper == null) {
            return false;
        }
        return this.gdsHelper.getDatabaseParameterBuffer().hasArgument(140);
    }

    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch (this.requiredType) {
            case -1: 
            case 1: 
            case 12: {
                if (this.isOctetsAsBytes() && this.field.sqlsubtype == 1) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case 2: 
            case 3: {
                if (this.scale == -1) {
                    return this.getBigDecimal();
                }
                return this.getBigDecimal(this.scale);
            }
            case -7: 
            case 16: {
                return new Boolean(this.getBoolean());
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt());
            }
            case -5: {
                return new Long(this.getLong());
            }
            case 7: {
                return new Float(this.getFloat());
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble());
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes();
            }
            case 91: {
                return this.getDate();
            }
            case 92: {
                return this.getTime();
            }
            case 93: {
                return this.getTimestamp();
            }
            case 2005: {
                return this.getClob();
            }
            case 2004: {
                return this.getBlob();
            }
            case 2003: {
                return this.getArray();
            }
        }
        throw (SQLException)FBField.createException(OBJECT_CONVERSION_ERROR);
    }

    public Object getObject(Map map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public InputStream getAsciiStream() throws SQLException {
        throw (SQLException)FBField.createException(ASCII_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public InputStream getUnicodeStream() throws SQLException {
        throw (SQLException)FBField.createException(UNICODE_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public InputStream getBinaryStream() throws SQLException {
        throw (SQLException)FBField.createException(BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public Reader getCharacterStream() throws SQLException {
        InputStream is = this.getBinaryStream();
        if (is == null) {
            return READER_NULL_VALUE;
        }
        return TranslatingReader.getInstance(is, this.javaEncoding, this.mappingPath);
    }

    public byte[] getBytes() throws SQLException {
        throw (SQLException)FBField.createException(BYTES_CONVERSION_ERROR).fillInStackTrace();
    }

    public Blob getBlob() throws SQLException {
        throw (SQLException)FBField.createException(BLOB_CONVERSION_ERROR).fillInStackTrace();
    }

    public Date getDate() throws SQLException {
        throw (SQLException)FBField.createException(DATE_CONVERSION_ERROR).fillInStackTrace();
    }

    public Date getDate(Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(DATE_CONVERSION_ERROR).fillInStackTrace();
    }

    public Time getTime() throws SQLException {
        throw (SQLException)FBField.createException(TIME_CONVERSION_ERROR).fillInStackTrace();
    }

    public Time getTime(Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(TIME_CONVERSION_ERROR).fillInStackTrace();
    }

    public Timestamp getTimestamp() throws SQLException {
        throw (SQLException)FBField.createException(TIMESTAMP_CONVERSION_ERROR).fillInStackTrace();
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(TIMESTAMP_CONVERSION_ERROR).fillInStackTrace();
    }

    public Ref getRef() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public Clob getClob() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public Array getArray() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setByte(byte value) throws SQLException {
        throw (SQLException)FBField.createException(BYTE_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setShort(short value) throws SQLException {
        throw (SQLException)FBField.createException(SHORT_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setInteger(int value) throws SQLException {
        throw (SQLException)FBField.createException(INT_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setLong(long value) throws SQLException {
        throw (SQLException)FBField.createException(LONG_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setFloat(float value) throws SQLException {
        throw (SQLException)FBField.createException(FLOAT_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setDouble(double value) throws SQLException {
        throw (SQLException)FBField.createException(DOUBLE_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        throw (SQLException)FBField.createException(BIGDECIMAL_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setBoolean(boolean value) throws SQLException {
        throw (SQLException)FBField.createException(BOOLEAN_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setString(String value) throws SQLException {
        throw (SQLException)FBField.createException(STRING_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof BigDecimal) {
            this.setBigDecimal((BigDecimal)value);
        } else if (value instanceof Blob) {
            if (value instanceof FBBlob) {
                this.setBlob((FBBlob)value);
            } else {
                this.setBinaryStream(((Blob)value).getBinaryStream(), (int)((Blob)value).length());
            }
        } else if (value instanceof Boolean) {
            this.setBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.setBytes((byte[])value);
        } else if (value instanceof Date) {
            this.setDate((Date)value);
        } else if (value instanceof Double) {
            this.setDouble((Double)value);
        } else if (value instanceof Float) {
            this.setFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.setInteger((Integer)value);
        } else if (value instanceof Long) {
            this.setLong((Long)value);
        } else if (value instanceof Short) {
            this.setShort((Short)value);
        } else if (value instanceof String) {
            this.setString((String)value);
        } else if (value instanceof Time) {
            this.setTime((Time)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp((Timestamp)value);
        } else {
            throw (SQLException)FBField.createException(OBJECT_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    public void setAsciiStream(InputStream in, int length) throws SQLException {
        throw (SQLException)FBField.createException(ASCII_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setUnicodeStream(InputStream in, int length) throws SQLException {
        throw (SQLException)FBField.createException(UNICODE_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        throw (SQLException)FBField.createException(BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setCharacterStream(Reader in, int length) throws SQLException {
        throw (SQLException)FBField.createException(ASCII_STREAM_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setBytes(byte[] value) throws SQLException {
        throw (SQLException)FBField.createException(BYTES_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(DATE_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setDate(Date value) throws SQLException {
        throw (SQLException)FBField.createException(DATE_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(TIME_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setTime(Time value) throws SQLException {
        throw (SQLException)FBField.createException(TIME_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        throw (SQLException)FBField.createException(TIMESTAMP_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        throw (SQLException)FBField.createException(TIMESTAMP_CONVERSION_ERROR).fillInStackTrace();
    }

    public void setBlob(FBBlob blob) throws SQLException {
        throw (SQLException)FBField.createException(BLOB_CONVERSION_ERROR).fillInStackTrace();
    }

    void copyOI() {
        this.dataProvider.setFieldData(this.dataProvider.getFieldData());
    }

    protected boolean isInvertTimeZone() {
        if (this.gdsHelper == null) {
            return false;
        }
        DatabaseParameterBuffer dpb = this.gdsHelper.getDatabaseParameterBuffer();
        return dpb.hasArgument(133);
    }
}

