/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class ForecastJobRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField DURATION = new ParseField("duration", new String[0]);
    public static final ParseField EXPIRES_IN = new ParseField("expires_in", new String[0]);
    public static final ParseField MAX_MODEL_MEMORY = new ParseField("max_model_memory", new String[0]);
    public static final ConstructingObjectParser<ForecastJobRequest, Void> PARSER = new ConstructingObjectParser("forecast_job_request", a -> new ForecastJobRequest((String)a[0]));
    private final String jobId;
    private TimeValue duration;
    private TimeValue expiresIn;
    private ByteSizeValue maxModelMemory;

    public ForecastJobRequest(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getDuration() {
        return this.duration;
    }

    public void setDuration(TimeValue duration) {
        this.duration = duration;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(TimeValue expiresIn) {
        this.expiresIn = expiresIn;
    }

    public ByteSizeValue getMaxModelMemory() {
        return this.maxModelMemory;
    }

    public ForecastJobRequest setMaxModelMemory(ByteSizeValue maxModelMemory) {
        this.maxModelMemory = maxModelMemory;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.duration, this.expiresIn, this.maxModelMemory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ForecastJobRequest other = (ForecastJobRequest)((Object)obj);
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.duration, other.duration) && Objects.equals(this.expiresIn, other.expiresIn) && Objects.equals(this.maxModelMemory, other.maxModelMemory);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.duration != null) {
            builder.field(DURATION.getPreferredName(), this.duration.getStringRep());
        }
        if (this.expiresIn != null) {
            builder.field(EXPIRES_IN.getPreferredName(), this.expiresIn.getStringRep());
        }
        if (this.maxModelMemory != null) {
            builder.field(MAX_MODEL_MEMORY.getPreferredName(), this.maxModelMemory.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString((request, val) -> request.setDuration(TimeValue.parseTimeValue((String)val, (String)DURATION.getPreferredName())), DURATION);
        PARSER.declareString((request, val) -> request.setExpiresIn(TimeValue.parseTimeValue((String)val, (String)EXPIRES_IN.getPreferredName())), EXPIRES_IN);
        PARSER.declareField(ForecastJobRequest::setMaxModelMemory, (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_MODEL_MEMORY.getPreferredName());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new ByteSizeValue(p.longValue());
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, MAX_MODEL_MEMORY, ObjectParser.ValueType.VALUE);
    }
}

