/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class SelectChannelConnector
extends AbstractNIOConnector {
    protected ServerSocketChannel _acceptChannel;
    private int _lowResourcesConnections;
    private int _lowResourcesMaxIdleTime;
    private final SelectorManager _manager = new SelectorManager(){

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
            if (channel == null) {
                return null;
            }
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            SelectChannelConnector.this.configure(socket);
            return channel;
        }

        public boolean dispatch(Runnable task) {
            return SelectChannelConnector.this.getThreadPool().dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionClosed(endpoint.getConnection());
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened(endpoint.getConnection());
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            SelectChannelConnector.this.connectionUpgraded(oldConnection, endpoint.getConnection());
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return SelectChannelConnector.this.newConnection(channel, endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    };

    public void accept(int acceptorID) throws IOException {
        this._manager.doSelect(acceptorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._manager.isRunning()) {
                try {
                    this._manager.stop();
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        SelectChannelEndPoint cep = (SelectChannelEndPoint)endpoint;
        cep.cancelIdle();
        request.setTimeStamp(cep.getSelectSet().getNow());
        super.customize(endpoint, request);
    }

    public void persist(EndPoint endpoint) throws IOException {
        ((SelectChannelEndPoint)endpoint).scheduleIdle();
        super.persist(endpoint);
    }

    public Object getConnection() {
        return this._acceptChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
                return -1;
            }
            return this._acceptChannel.socket().getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.configureBlocking(true);
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                if (this._acceptChannel.socket().getLocalPort() == -1) {
                    throw new IOException("Server channel not bound");
                }
                this._acceptChannel.configureBlocking(false);
            }
        }
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime((long)maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    public int getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(int lowResourcesConnections) {
        this._lowResourcesConnections = lowResourcesConnections;
    }

    public int getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(int lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourcesMaxIdleTime(lowResourcesMaxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime((long)this.getMaxIdleTime());
        this._manager.setLowResourcesConnections((long)this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime((long)this.getLowResourcesMaxIdleTime());
        this._manager.start();
        this.open();
        this._manager.register(this._acceptChannel);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new SelectChannelEndPoint(channel, selectSet, key);
    }

    protected Connection newConnection(SocketChannel channel, final SelectChannelEndPoint endpoint) {
        return new HttpConnection(this, (EndPoint)endpoint, this.getServer()){

            public void cancelTimeout(Timeout.Task task) {
                endpoint.getSelectSet().cancelTimeout(task);
            }

            public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
                endpoint.getSelectSet().scheduleTimeout(task, timeoutMs);
            }
        };
    }

    public void dump() {
        Log.info((String)("channel " + this._acceptChannel + (this._acceptChannel.isOpen() ? " is open" : " is closed")));
        this._manager.dump();
    }
}

