/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.nmea;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class NMEA0183Sentence {
    protected String raw_data_;
    protected String talker_id_ = null;
    protected String sentence_id_ = null;
    protected byte checksum_ = (byte)-1;
    protected byte calculated_checksum_ = (byte)-1;
    protected List data_fields_ = null;
    private static Logger logger_ = Logger.getLogger((Class)NMEA0183Sentence.class);

    public NMEA0183Sentence(String raw_data) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("raw data='" + raw_data + "'"));
        }
        int star_pos = raw_data.indexOf(42);
        if (raw_data.startsWith("$PSRFTXT")) {
            this.raw_data_ = raw_data;
        } else {
            if (star_pos <= 6) {
                throw new IllegalArgumentException("Invalid NMEA Sentence (no '*'): " + new String(raw_data));
            }
            this.raw_data_ = raw_data.substring(0, star_pos + 3);
        }
    }

    public NMEA0183Sentence(byte[] raw_data, int offset, int length) {
        this(new String(raw_data, offset, length));
    }

    public NMEA0183Sentence(char[] raw_data, int offset, int length) {
        this(new String(raw_data, offset, length));
    }

    public NMEA0183Sentence(char[] raw_data) {
        this(new String(raw_data));
    }

    public String getTalkerId() {
        if (this.talker_id_ == null) {
            this.talker_id_ = this.raw_data_.substring(1, 3);
        }
        return this.talker_id_;
    }

    public String getSentenceId() {
        if (this.sentence_id_ == null) {
            int comma_pos = this.raw_data_.indexOf(44);
            if (comma_pos < 0) {
                comma_pos = 6;
            }
            this.sentence_id_ = this.raw_data_.substring(3, comma_pos);
        }
        return this.sentence_id_;
    }

    public List getDataFields() {
        if (this.data_fields_ == null) {
            this.retrieveDataFieldsAndChecksum();
        }
        return this.data_fields_;
    }

    public byte getChecksum() {
        if (this.checksum_ < 0) {
            this.retrieveDataFieldsAndChecksum();
        }
        return this.checksum_;
    }

    public byte getCalculatedChecksum() {
        if (this.calculated_checksum_ < 0) {
            if (this.checksum_ < 0) {
                this.retrieveDataFieldsAndChecksum();
            }
            this.calculated_checksum_ = this.calcChecksum();
        }
        return this.calculated_checksum_;
    }

    public boolean isValid() {
        return this.getChecksum() == this.getCalculatedChecksum();
    }

    protected void retrieveDataFieldsAndChecksum() {
        if (this.data_fields_ == null) {
            this.data_fields_ = new ArrayList();
        }
        StringTokenizer tokenizer = new StringTokenizer(this.raw_data_, ",*", true);
        tokenizer.nextElement();
        if (tokenizer.hasMoreElements()) {
            tokenizer.nextElement();
        }
        String element = "";
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.equals(",")) {
                this.data_fields_.add(element);
                element = "";
                continue;
            }
            if (token.equals("*")) {
                this.data_fields_.add(element);
                element = "";
                this.checksum_ = NMEA0183Sentence.decodeChecksum(tokenizer.nextToken());
                if (!tokenizer.hasMoreElements()) continue;
                System.err.println("WARNING: too long NMEA sentence, elements after checksum found: " + this.raw_data_);
                continue;
            }
            element = token;
        }
        this.data_fields_.add(element);
    }

    public boolean equals(NMEA0183Sentence object) {
        return object.raw_data_.equals(this.raw_data_);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NMEA0183Sentence)) {
            return false;
        }
        return this.equals((NMEA0183Sentence)object);
    }

    protected static byte decodeChecksum(String checksum_string) {
        if (checksum_string == null || checksum_string.equals("")) {
            throw new IllegalArgumentException("checksum must not be null or empty!");
        }
        return Byte.parseByte(checksum_string, 16);
    }

    protected byte calcChecksum() {
        int start = this.raw_data_.indexOf(36);
        int end = this.raw_data_.indexOf(42);
        if (end < 0) {
            end = this.raw_data_.length();
        }
        byte checksum = (byte)this.raw_data_.charAt(start + 1);
        for (int index = start + 2; index < end; ++index) {
            checksum = (byte)(checksum ^ (byte)this.raw_data_.charAt(index));
        }
        return checksum;
    }

    protected static byte hexCharToByte(char hex_char) {
        if (hex_char > '9') {
            return (byte)(hex_char - 55);
        }
        return (byte)(hex_char - 48);
    }

    public String toString() {
        return this.raw_data_;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            NMEA0183Sentence s = new NMEA0183Sentence(args[0]);
            System.out.println("Sentence: " + s);
            System.out.println("talkId: " + s.getTalkerId());
            System.out.println("sentId: " + s.getSentenceId());
            System.out.println("datafields: " + s.getDataFields());
            System.out.println("checksum: " + s.getChecksum());
            System.out.println("calculated checksum: " + s.getCalculatedChecksum());
            System.out.println("valid: " + s.isValid());
        } else {
            NMEA0183Sentence s = new NMEA0183Sentence("$HCHDG,219.5,,,2.5,E*21");
            System.out.println("Sentence: " + s);
            System.out.println("talkId: " + s.getTalkerId());
            System.out.println("sentId: " + s.getSentenceId());
            System.out.println("datafields: " + s.getDataFields());
            System.out.println("checksum: " + s.getChecksum());
            System.out.println("calculated checksum: " + s.getCalculatedChecksum());
            System.out.println("valid: " + s.isValid());
        }
    }
}

