/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointBase;

public class GarminWaypointD100
extends GarminWaypointBase {
    protected static final byte WAYPOINT_TYPE = 100;

    public GarminWaypointD100() {
    }

    public GarminWaypointD100(int[] buffer) {
        this.identification_ = GarminDataConverter.getGarminString(buffer, 2, 6).trim();
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 8);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 12);
        this.comment_ = GarminDataConverter.getGarminString(buffer, 20, 40).trim();
    }

    public GarminWaypointD100(GarminPacket pack) {
        this.identification_ = pack.getNextAsString(6).trim();
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        pack.getNextAsLongWord();
        this.comment_ = pack.getNextAsString(40).trim();
    }

    public GarminWaypointD100(GPSWaypoint waypoint) {
        String tmp = waypoint.getIdentification();
        this.identification_ = tmp == null ? "" : tmp;
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        tmp = waypoint.getComment();
        this.comment_ = tmp == null ? "" : tmp;
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 58;
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsString(this.identification_, 6, false);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsLongWord(0L);
        pack.setNextAsString(this.comment_, 40, false);
        return pack;
    }

    public byte getType() {
        return 100;
    }
}

