/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.GPSTrack;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminTrack;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointD108;

public class GarminTrackD310
extends GarminTrack {
    public GarminTrackD310(int[] buffer) {
        this.setDisplayed(GarminDataConverter.getGarminBoolean(buffer, 2));
        int color_index = GarminDataConverter.getGarminByte(buffer, 3);
        if (color_index == 255) {
            color_index = 15;
        }
        this.setColor(GarminWaypointD108.COLORS[color_index]);
        this.setIdentification(GarminDataConverter.getGarminString(buffer, 4));
    }

    public GarminTrackD310(GarminPacket pack) {
        this.setDisplayed(pack.getNextAsBoolean());
        int color_index = pack.getNextAsByte();
        if (color_index == 255) {
            color_index = 15;
        }
        this.setColor(GarminWaypointD108.COLORS[color_index]);
        this.setIdentification(pack.getNextAsString(pack.getPacketSize() - 2));
    }

    public GarminTrackD310(GPSTrack track) {
        this.setDisplayed(track.isDisplayed());
        this.setColor(track.getColor());
        this.setIdentification(track.getIdentification());
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 2 + Math.min(this.getIdentification().length() + 1, 51);
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsBoolean(this.isDisplayed());
        boolean color_found = false;
        int color_index = 0;
        while (color_index < GarminWaypointD108.COLORS.length && !color_found) {
            if (GarminWaypointD108.COLORS[color_index].equals(this.color_)) {
                color_found = true;
                continue;
            }
            ++color_index;
        }
        if (this.color_ == null || !color_found) {
            pack.setNextAsByte(15);
        } else {
            pack.setNextAsByte(color_index);
        }
        pack.setNextAsString(this.getIdentification(), 51, true);
        return pack;
    }
}

