/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;

public class GarminRouteLinkD210 {
    int class_;
    String class_name_;
    byte[] subclass_;
    String identification_ = "";
    public static final String[] CLASS_NAME = new String[]{"line", "link", "net", "direct", "snap"};

    public GarminRouteLinkD210() {
    }

    public GarminRouteLinkD210(int[] buffer) {
        this.class_ = GarminDataConverter.getGarminWord(buffer, 2);
        this.subclass_ = GarminDataConverter.getGarminByteArray(buffer, 4, 18);
        this.identification_ = GarminDataConverter.getGarminString(buffer, 22, buffer[1] - 21);
    }

    public GarminRouteLinkD210(GarminPacket pack) {
        this.class_ = pack.getNextAsWord();
        this.subclass_ = pack.getNextAsByteArray(18);
        this.identification_ = pack.getNextAsString(51);
    }

    public int getClassId() {
        return this.class_;
    }

    public void setClassId(int class_id) {
        this.class_ = class_id;
    }

    public static String getClassName(int class_id) {
        if (class_id == 255) {
            return CLASS_NAME[CLASS_NAME.length - 1];
        }
        if (class_id < CLASS_NAME.length - 1) {
            return CLASS_NAME[class_id];
        }
        return "unknown";
    }

    public byte[] getSubclass() {
        return this.subclass_;
    }

    public void setSubclass(byte[] subclass) {
        if (subclass.length != 18) {
            throw new IllegalArgumentException("Subclass is not byte[18]!");
        }
        this.subclass_ = subclass;
    }

    public String getIdentification() {
        return this.identification_;
    }

    public void setIdentification(String identification) {
        this.identification_ = identification;
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 20 + Math.min(this.identification_.length() + 1, 51);
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsWord(this.class_);
        pack.setNextAsByteArray(this.subclass_);
        pack.setNextAsString(this.identification_, 51, true);
        return pack;
    }

    public String toString() {
        StringBuffer subclass = new StringBuffer();
        for (int count = 0; count < this.subclass_.length - 1; ++count) {
            subclass.append(Integer.toHexString(this.subclass_[count] & 0xFF)).append(",");
        }
        subclass.append(Integer.toHexString(this.subclass_[this.subclass_.length - 1] & 0xFF));
        return "GarminRouteLinkD210[class=" + this.class_ + ", class_name=" + GarminRouteLinkD210.getClassName(this.class_) + ", identification=" + this.identification_ + ",subclass=" + subclass.toString() + "]";
    }
}

