/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class GarminDataConverter {
    protected static final double SEMICIRCLE_FACTOR = 1.1930464711111112E7;
    public static long garmin_zero_date_seconds_;

    public static byte[] getGarminByteArray(int[] buffer, int offset, int length) {
        byte[] value = new byte[length];
        for (int index = length - 1; index >= 0; --index) {
            value[index] = (byte)(buffer[offset + index] & 0xFF);
        }
        return value;
    }

    public static int[] setGarminByteArray(byte[] byteArray, int[] buffer, int offset) {
        for (int index = 0; index < byteArray.length; ++index) {
            buffer = GarminDataConverter.setGarminByte(byteArray[index], buffer, offset + index);
        }
        return buffer;
    }

    public static String getGarminString(int[] buffer, int offset) {
        return GarminDataConverter.getGarminString(buffer, offset, buffer.length);
    }

    public static String getGarminString(int[] buffer, int offset, int max_length) {
        StringBuffer result = new StringBuffer();
        int max_index = Math.min(offset + max_length, buffer.length);
        for (int index = offset; index < max_index; ++index) {
            int ch = buffer[index];
            if (ch == 0) {
                return result.toString();
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    public static int[] setGarminString(String string, int[] buffer, int offset, int max_length, boolean zero_terminate) {
        int index;
        if (zero_terminate) {
            --max_length;
        }
        for (index = 0; index < string.length() && index < max_length; ++index) {
            buffer[offset + index] = string.charAt(index);
        }
        if (!zero_terminate) {
            while (index < max_length) {
                buffer[offset + index] = 32;
                ++index;
            }
        } else {
            buffer[offset + index] = 0;
        }
        return buffer;
    }

    public static boolean getGarminBoolean(int[] buffer, int offset) {
        return buffer[offset] != 0;
    }

    public static int[] setGarminBoolean(boolean bool, int[] buffer, int offset) {
        buffer[offset] = bool ? 1 : 0;
        return buffer;
    }

    public static short getGarminByte(int[] buffer, int offset) {
        return (short)(buffer[offset] & 0xFF);
    }

    public static int[] setGarminByte(int byt, int[] buffer, int offset) {
        buffer[offset] = byt & 0xFF;
        return buffer;
    }

    public static int getGarminUnsignedInt(int[] buffer, int offset) {
        int value = buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8;
        return value;
    }

    public static int[] setGarminUnsignedInt(int word, int[] buffer, int offset) {
        buffer[offset] = word & 0xFF;
        buffer[offset + 1] = (word & 0xFF00) >> 8;
        return buffer;
    }

    public static int getGarminSignedInt(int[] buffer, int offset) {
        int value = GarminDataConverter.getGarminUnsignedInt(buffer, offset);
        if ((value & 0x8000) == 0) {
            return value;
        }
        return -(~((value | 0xFFFF0000) - 1));
    }

    public static int[] setGarminSignedInt(int word, int[] buffer, int offset) {
        if (word < 0) {
            word = ~(-word) + 1;
            buffer[offset + 1] = (word & 0x7F00 | 0x8000) >> 8;
        } else {
            buffer[offset + 1] = (word & 0x7F00) >> 8;
        }
        buffer[offset] = word & 0xFF;
        return buffer;
    }

    public static int getGarminWord(int[] buffer, int offset) {
        return GarminDataConverter.getGarminUnsignedInt(buffer, offset);
    }

    public static int[] setGarminWord(int word, int[] buffer, int offset) {
        return GarminDataConverter.setGarminUnsignedInt(word, buffer, offset);
    }

    public static int getGarminInt(int[] buffer, int offset) {
        return GarminDataConverter.getGarminSignedInt(buffer, offset);
    }

    public static int[] setGarminInt(int integer, int[] buffer, int offset) {
        return GarminDataConverter.setGarminSignedInt(integer, buffer, offset);
    }

    public static long getGarminUnsignedLong(int[] buffer, int offset) {
        long value = (long)(buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8) | (long)(buffer[offset + 2] & 0xFF) << 16 | (long)(buffer[offset + 3] & 0xFF) << 24;
        return value;
    }

    public static int[] setGarminUnsignedLong(long longword, int[] buffer, int offset) {
        buffer[offset] = (int)(longword & 0xFFL);
        buffer[offset + 1] = (int)(longword & 0xFF00L) >> 8;
        buffer[offset + 2] = (int)(longword & 0xFF0000L) >> 16;
        buffer[offset + 3] = (int)(longword & 0xFFFFFFFFFF000000L) >> 24;
        return buffer;
    }

    public static long getGarminSignedLong(int[] buffer, int offset) {
        long value = GarminDataConverter.getGarminUnsignedLong(buffer, offset);
        if ((value & 0x80000000L) == 0L) {
            return value;
        }
        return -((value | 0xFFFFFFFF00000000L) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int[] setGarminSignedLong(long longword, int[] buffer, int offset) {
        if (longword < 0L) {
            longword = (-longword ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
            buffer[offset + 3] = (int)(longword & 0x7F000000L | 0x80000000L) >> 24;
        } else {
            buffer[offset + 3] = (int)(longword & 0x7F000000L) >> 24;
        }
        buffer[offset] = (int)longword & 0xFF;
        buffer[offset + 1] = (int)(longword & 0xFF00L) >> 8;
        buffer[offset + 2] = (int)(longword & 0xFF0000L) >> 16;
        return buffer;
    }

    public static long getGarminLongWord(int[] buffer, int offset) {
        return GarminDataConverter.getGarminUnsignedLong(buffer, offset);
    }

    public static int[] setGarminLongWord(long longword, int[] buffer, int offset) {
        return GarminDataConverter.setGarminUnsignedLong(longword, buffer, offset);
    }

    public static float getGarminFloat(int[] buffer, int offset) {
        int value = buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
        return Float.intBitsToFloat(value);
    }

    public static int[] setGarminFloat(float flo, int[] buffer, int offset) {
        int integer = Float.floatToRawIntBits(flo);
        return GarminDataConverter.setGarminLongWord(integer, buffer, offset);
    }

    public static double getGarminDouble(int[] buffer, int offset) {
        long value = (long)(buffer[offset] & 0xFF) | (long)(buffer[offset + 1] & 0xFF) << 8 | (long)(buffer[offset + 2] & 0xFF) << 16 | (long)(buffer[offset + 3] & 0xFF) << 24 | (long)(buffer[offset + 4] & 0xFF) << 32 | (long)(buffer[offset + 5] & 0xFF) << 40 | (long)(buffer[offset + 6] & 0xFF) << 48 | (long)(buffer[offset + 7] & 0xFF) << 56;
        return Double.longBitsToDouble(value);
    }

    public static int[] setGarminDouble(double doub, int[] buffer, int offset) {
        long value = Double.doubleToRawLongBits(doub);
        buffer[offset + 0] = (int)((value & 0xFFL) >> 0);
        buffer[offset + 1] = (int)((value & 0xFF00L) >> 8);
        buffer[offset + 2] = (int)((value & 0xFF0000L) >> 16);
        buffer[offset + 3] = (int)((value & 0xFFFFFFFFFF000000L) >> 24);
        buffer[offset + 4] = (int)((value >> 32 & 0xFFL) >> 0);
        buffer[offset + 5] = (int)((value >> 32 & 0xFF00L) >> 8);
        buffer[offset + 6] = (int)((value >> 32 & 0xFF0000L) >> 16);
        buffer[offset + 7] = (int)((value >> 32 & 0xFFFFFFFFFF000000L) >> 24);
        return buffer;
    }

    public static double getGarminSemicircleDegrees(int[] buffer, int offset) {
        return GarminDataConverter.convertSemicirclesToDegrees(GarminDataConverter.getGarminSignedLong(buffer, offset));
    }

    public static int[] setGarminSemicircleDegrees(double degrees, int[] buffer, int offset) {
        return GarminDataConverter.setGarminSignedLong(GarminDataConverter.convertDegreesToSemicircles(degrees), buffer, offset);
    }

    public static double getGarminRadiantDegrees(int[] buffer, int offset) {
        return Math.toDegrees(GarminDataConverter.getGarminDouble(buffer, offset));
    }

    public static int[] setGarminRadiantDegrees(double degrees, int[] buffer, int offset) {
        return GarminDataConverter.setGarminDouble(Math.toRadians(degrees), buffer, offset);
    }

    public static double convertSemicirclesToDegrees(long semicircle) {
        return (double)semicircle / 1.1930464711111112E7;
    }

    public static long convertDegreesToSemicircles(double degrees) {
        return (long)(degrees * 1.1930464711111112E7);
    }

    public static long convertDateToGarminTime(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime() / 1000L - garmin_zero_date_seconds_;
    }

    public static Date convertGarminTimeToDate(long garmin_time) {
        if (garmin_time < 0L || garmin_time == 0xFFFFFFFFL) {
            return null;
        }
        return new Date((garmin_zero_date_seconds_ + garmin_time) * 1000L);
    }

    public static void main(String[] args) {
        int[] buffer = new int[]{90, 17, 52, 173};
        long value = GarminDataConverter.getGarminLongWord(buffer, 0);
        if (value != 2905870682L) {
            System.out.println("Wrong: " + value);
        } else {
            System.out.println("Right!");
        }
        int[] buffer1 = new int[]{255, 255};
        int value1 = GarminDataConverter.getGarminSignedInt(buffer1, 0);
        if (value1 != -1) {
            System.out.println("Wrong: " + value1);
        } else {
            System.out.println("Right!");
        }
        buffer1 = GarminDataConverter.setGarminSignedInt(-1, buffer1, 0);
        if (buffer1[0] != 255 && buffer1[1] != 255) {
            System.out.println("Wrong! " + Integer.toHexString(buffer1[0]) + "," + Integer.toHexString(buffer1[1]));
        } else {
            System.out.println("Right!");
        }
        int[] buffer2 = new int[]{255, 255, 255, 255};
        long value2 = GarminDataConverter.getGarminSignedLong(buffer2, 0);
        if (value2 != -1L) {
            System.out.println("Wrong: " + value2);
        } else {
            System.out.println("Right!");
        }
        buffer2 = GarminDataConverter.setGarminSignedInt(-1, buffer2, 0);
        if (buffer2[0] != 255 && buffer2[1] != 255 && buffer2[2] != 255 && buffer2[3] != 255) {
            System.out.println("Wrong! " + Integer.toHexString(buffer2[0]) + "," + Integer.toHexString(buffer2[1]) + "," + Integer.toHexString(buffer2[2]) + "," + Integer.toHexString(buffer2[3]));
        } else {
            System.out.println("Right!");
        }
        Date now = new Date();
        long garmin_now = GarminDataConverter.convertDateToGarminTime(now);
        System.out.println(now + ":" + Long.toHexString(garmin_now));
        System.out.println(now + ":" + garmin_now);
        System.out.println(GarminDataConverter.convertGarminTimeToDate(garmin_now));
        buffer2 = GarminDataConverter.setGarminLongWord(garmin_now, buffer2, 0);
        long garmin_now2 = GarminDataConverter.getGarminLongWord(buffer2, 0);
        System.out.println(GarminDataConverter.convertGarminTimeToDate(garmin_now2));
        System.out.println("zero:" + GarminDataConverter.convertGarminTimeToDate(0L));
    }

    static {
        TimeZone timezone = TimeZone.getTimeZone("Etc/UTC");
        Calendar garmin_zero = Calendar.getInstance(timezone);
        garmin_zero.set(5, 0);
        garmin_zero.set(2, 0);
        garmin_zero.set(1, 1990);
        garmin_zero.set(11, 0);
        garmin_zero.set(12, 0);
        garmin_zero.set(13, 0);
        garmin_zero.set(14, 0);
        garmin_zero_date_seconds_ = garmin_zero.getTime().getTime() / 1000L;
    }
}

