/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSGeneralDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSPosition;

public class GPSSimulationDataProcessor
extends GPSGeneralDataProcessor
implements Runnable {
    Thread simulation_thread_;
    GPSPosition destination_;
    GPSPosition current_position_;
    float current_heading_;
    float speed_ = 1.0f;
    boolean stopped_ = false;
    public static final int SLEEP_TIME = 2;
    public static final int SECONDS_TO_DESTINATION = 60;
    private static Logger logger_ = Logger.getLogger((Class)GPSSimulationDataProcessor.class);

    public String[] getGPSInfo() {
        String[] info = new String[]{"Simulation data"};
        return info;
    }

    public long startSendPositionPeriodically(long period) throws GPSException {
        return 2000L;
    }

    public void stopSendPositionPeriodically() throws GPSException {
        this.stopped_ = true;
    }

    public void setStartPosition(GPSPosition start) {
        this.current_position_ = new GPSPosition(start);
    }

    public void setDestinationPosition(GPSPosition destination) {
        this.destination_ = destination;
    }

    public void setDestinationPosition(float speed) {
        this.speed_ = speed;
    }

    public void open() {
        if (!this.stopped_) {
            this.close();
        }
        this.stopped_ = false;
        this.simulation_thread_ = new Thread((Runnable)this, "GPSSimulationDataProcessor");
        this.simulation_thread_.setDaemon(true);
        this.simulation_thread_.start();
    }

    public void close() {
        this.stopped_ = true;
        if (this.simulation_thread_ != null) {
            this.simulation_thread_.interrupt();
        }
    }

    public void run() {
        double last_latitude = this.current_position_.getLatitude();
        double last_longitude = this.current_position_.getLongitude();
        this.changeGPSData("location", this.current_position_);
        this.changeGPSData("heading", new Float(this.current_heading_));
        while (!this.stopped_) {
            double diff_lat = this.destination_.getLatitude() - this.current_position_.getLatitude();
            double diff_long = this.destination_.getLongitude() - this.current_position_.getLongitude();
            double distance = Math.sqrt(diff_lat * diff_lat + diff_long * diff_long);
            double step_lat = diff_lat / 30.0;
            double step_long = diff_long / 30.0;
            step_lat *= Math.random() * 0.4 + 0.8;
            step_long *= Math.random() * 0.4 + 0.8;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("simulation thread diff_lat=" + diff_lat + " diff_long=" + diff_long + " current step (lat/long)=" + step_lat + "/" + step_long));
            }
            this.current_heading_ = (float)Math.toDegrees(Math.atan2(step_lat, step_long));
            this.current_heading_ = 90.0f - this.current_heading_;
            if (this.current_heading_ < 0.0f) {
                this.current_heading_ = 360.0f + this.current_heading_;
            }
            this.current_position_ = new GPSPosition();
            this.current_position_.setLatitude(last_latitude + step_lat);
            this.current_position_.setLongitude(last_longitude + step_long);
            last_latitude = this.current_position_.getLatitude();
            last_longitude = this.current_position_.getLongitude();
            this.changeGPSData("location", this.current_position_);
            this.changeGPSData("heading", new Float(this.current_heading_));
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("GPSSimulationDataProcessor: new location" + this.current_position_));
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)"GPSSimulationDataProcessor: simulation thread stopped.");
                }
                return;
            }
        }
    }

    public GPSPosition getGPSPosition() {
        return this.current_position_;
    }

    public float getHeading() {
        return this.current_heading_;
    }
}

