/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.shiro;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.PropertiesRealm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.ShiroHttpServletResponse;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.apache.shiro.web.subject.WebSubject;
import org.debux.webmotion.server.WebMotionServerListener;
import org.debux.webmotion.server.call.ServerContext;
import org.debux.webmotion.server.mapping.Mapping;
import org.debux.webmotion.shiro.Shiro;

public class ShiroListener
implements WebMotionServerListener {
    protected static Filter filter = new Filter(){

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, final FilterChain chain) throws IOException, ServletException {
            Throwable t = null;
            try {
                final ServletRequest request = this.prepareServletRequest(servletRequest, servletResponse, chain);
                final ServletResponse response = this.prepareServletResponse(request, servletResponse, chain);
                WebSubject subject = this.createSubject(request, response);
                subject.execute(new Callable(){

                    public Object call() throws Exception {
                        this.executeChain(request, response, chain);
                        return null;
                    }
                });
            }
            catch (ExecutionException ex) {
                t = ex.getCause();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
            if (t != null) {
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                String msg = "Filtered request failed.";
                throw new ServletException(msg, t);
            }
        }

        protected void executeChain(ServletRequest request, ServletResponse response, FilterChain origChain) throws IOException, ServletException {
            origChain.doFilter(request, response);
        }

        protected ServletResponse prepareServletResponse(ServletRequest request, ServletResponse response, FilterChain chain) {
            ServletResponse toUse = response;
            if (!this.isHttpSessions() && request instanceof ShiroHttpServletRequest && response instanceof HttpServletResponse) {
                toUse = this.wrapServletResponse((HttpServletResponse)response, (ShiroHttpServletRequest)request);
            }
            return toUse;
        }

        protected ServletRequest prepareServletRequest(ServletRequest request, ServletResponse response, FilterChain chain) {
            ServletRequest toUse = request;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest http = (HttpServletRequest)request;
                toUse = this.wrapServletRequest(http);
            }
            return toUse;
        }

        protected ServletResponse wrapServletResponse(HttpServletResponse orig, ShiroHttpServletRequest request) {
            return new ShiroHttpServletResponse(orig, request.getServletContext(), request);
        }

        protected ServletRequest wrapServletRequest(HttpServletRequest orig) {
            return new ShiroHttpServletRequest(orig, orig.getServletContext(), this.isHttpSessions());
        }

        protected boolean isHttpSessions() {
            return this.getSecurityManager().isHttpSessionMode();
        }

        protected WebSubject createSubject(ServletRequest request, ServletResponse response) {
            return new WebSubject.Builder((SecurityManager)this.getSecurityManager(), request, response).buildWebSubject();
        }

        public WebSecurityManager getSecurityManager() {
            return (WebSecurityManager)SecurityUtils.getSecurityManager();
        }

        public void destroy() {
        }
    };

    public void onStart(Mapping mapping, ServerContext context) {
        ServletContext servletContext = context.getServletContext();
        FilterRegistration.Dynamic registration = servletContext.addFilter("shiro", filter);
        registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ERROR), true, new String[]{"/*"});
        context.addGlobalController(Shiro.class);
        Realm realm = this.getRealm();
        if (realm instanceof AuthenticatingRealm) {
            AuthenticatingRealm authenticatingRealm = (AuthenticatingRealm)realm;
            authenticatingRealm.setCredentialsMatcher(this.getMatcher());
        }
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager(realm);
        securityManager.setSessionManager(this.getSessionManager());
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    public void onStop(ServerContext context) {
    }

    protected Realm getRealm() {
        PropertiesRealm realm = new PropertiesRealm();
        realm.setResourcePath("classpath:shiro.properties");
        realm.init();
        return realm;
    }

    protected CredentialsMatcher getMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-256");
        matcher.setStoredCredentialsHexEncoded(true);
        return matcher;
    }

    protected SessionManager getSessionManager() {
        ServletContainerSessionManager sessionManager = new ServletContainerSessionManager();
        return sessionManager;
    }
}

