/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.Format;
import org.cyclonedx.Version;
import org.cyclonedx.model.Bom;
import org.cyclonedx.util.serializer.CustomSerializerModifier;
import org.cyclonedx.util.serializer.EvidenceSerializer;
import org.cyclonedx.util.serializer.ExternalReferenceSerializer;
import org.cyclonedx.util.serializer.HashSerializer;
import org.cyclonedx.util.serializer.InputTypeSerializer;
import org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import org.cyclonedx.util.serializer.LifecycleSerializer;
import org.cyclonedx.util.serializer.MetadataSerializer;
import org.cyclonedx.util.serializer.OutputTypeSerializer;
import org.cyclonedx.util.serializer.SignatorySerializer;

public abstract class AbstractBomGenerator
extends CycloneDxSchema {
    protected ObjectMapper mapper = new ObjectMapper();
    protected final Version version;
    protected Bom bom;
    protected Format format;

    public AbstractBomGenerator(Version version, Bom bom, Format format) {
        this.version = version;
        this.bom = bom;
        this.format = format;
        if (!version.getFormats().contains((Object)format)) {
            throw new IllegalArgumentException("CycloneDX version " + version.getVersionString() + " does not support the " + (Object)((Object)format) + " format");
        }
    }

    public Version getSchemaVersion() {
        return this.version;
    }

    public Format getFormat() {
        return this.format;
    }

    protected void setupObjectMapper(boolean isXml) {
        SimpleModule licenseModule = new SimpleModule();
        licenseModule.addSerializer((JsonSerializer)new LicenseChoiceSerializer(isXml, this.version));
        this.mapper.registerModule((Module)licenseModule);
        SimpleModule lifecycleModule = new SimpleModule();
        lifecycleModule.addSerializer((JsonSerializer)new LifecycleSerializer(isXml));
        this.mapper.registerModule((Module)lifecycleModule);
        SimpleModule metadataModule = new SimpleModule();
        metadataModule.addSerializer((JsonSerializer)new MetadataSerializer(isXml, this.getSchemaVersion()));
        this.mapper.registerModule((Module)metadataModule);
        SimpleModule inputTypeModule = new SimpleModule();
        inputTypeModule.addSerializer((JsonSerializer)new InputTypeSerializer(isXml));
        this.mapper.registerModule((Module)inputTypeModule);
        SimpleModule outputTypeModule = new SimpleModule();
        outputTypeModule.addSerializer((JsonSerializer)new OutputTypeSerializer(isXml));
        this.mapper.registerModule((Module)outputTypeModule);
        SimpleModule evidenceModule = new SimpleModule();
        evidenceModule.addSerializer((JsonSerializer)new EvidenceSerializer(isXml, this.getSchemaVersion()));
        this.mapper.registerModule((Module)evidenceModule);
        SimpleModule signatoryModule = new SimpleModule();
        signatoryModule.addSerializer((JsonSerializer)new SignatorySerializer(isXml));
        this.mapper.registerModule((Module)signatoryModule);
        SimpleModule externalSerializer = new SimpleModule();
        externalSerializer.addSerializer((JsonSerializer)new ExternalReferenceSerializer(this.getSchemaVersion()));
        this.mapper.registerModule((Module)externalSerializer);
        SimpleModule hash1Module = new SimpleModule();
        hash1Module.addSerializer((JsonSerializer)new HashSerializer(this.version));
        this.mapper.registerModule((Module)hash1Module);
        SimpleModule propertiesModule = new SimpleModule();
        propertiesModule.setSerializerModifier((BeanSerializerModifier)new CustomSerializerModifier(isXml, this.version));
        this.mapper.registerModule((Module)propertiesModule);
    }
}

