/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.cyclonedx.model.Hash;

public final class BomUtils {
    private BomUtils() {
    }

    public static List<Hash> calculateHashes(File file) throws IOException {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            hashes.add(new Hash(Hash.Algorithm.MD5, DigestUtils.md5Hex((InputStream)fis)));
        }
        fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            hashes.add(new Hash(Hash.Algorithm.SHA1, DigestUtils.sha1Hex((InputStream)fis)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var3_3 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            hashes.add(new Hash(Hash.Algorithm.SHA_256, DigestUtils.sha256Hex((InputStream)fis)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var3_3 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            hashes.add(new Hash(Hash.Algorithm.SHA_384, DigestUtils.sha384Hex((InputStream)fis)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var3_3 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            hashes.add(new Hash(Hash.Algorithm.SHA_512, DigestUtils.sha512Hex((InputStream)fis)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var3_3 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        return hashes;
    }

    public static boolean validateUrlString(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

