/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jirareport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class FederatedResourceLoader
extends ResourceLoader {
    private List loaders = new ArrayList();

    public FederatedResourceLoader() {
        this.loaders.add(new FileResourceLoader());
        this.loaders.add(new SimplerFileResourceLoader());
        this.loaders.add(new URLResourceLoader());
        this.loaders.add(new ClasspathResourceLoader());
    }

    public void commonInit(RuntimeServices runtimeServices, ExtendedProperties extendedProperties) {
        for (int i = 0; i < this.loaders.size(); ++i) {
            ResourceLoader loader = (ResourceLoader)this.loaders.get(i);
            loader.commonInit(runtimeServices, extendedProperties);
        }
    }

    public InputStream getResourceStream(String string) throws ResourceNotFoundException {
        for (int i = 0; i < this.loaders.size(); ++i) {
            try {
                ResourceLoader loader = (ResourceLoader)this.loaders.get(i);
                InputStream resourceStream = loader.getResourceStream(string);
                return resourceStream;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                continue;
            }
        }
        throw new ResourceNotFoundException(string);
    }

    public void init(ExtendedProperties extendedProperties) {
        for (int i = 0; i < this.loaders.size(); ++i) {
            ResourceLoader loader = (ResourceLoader)this.loaders.get(i);
            loader.init(extendedProperties);
        }
    }

    public long getLastModified(Resource resource) {
        return System.currentTimeMillis();
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }

    public static class SimplerFileResourceLoader
    extends ResourceLoader {
        public long getLastModified(Resource resource) {
            return 0L;
        }

        public InputStream getResourceStream(String string) throws ResourceNotFoundException {
            try {
                File file = new File(string);
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw (ResourceNotFoundException)new ResourceNotFoundException(string).initCause(e);
            }
        }

        public void init(ExtendedProperties extendedProperties) {
        }

        public boolean isSourceModified(Resource resource) {
            return false;
        }
    }

    public static class URLResourceLoader
    extends ResourceLoader {
        public long getLastModified(Resource resource) {
            return 0L;
        }

        public InputStream getResourceStream(String string) throws ResourceNotFoundException {
            try {
                URL url = new URL(string);
                return url.openStream();
            }
            catch (IOException e) {
                throw (ResourceNotFoundException)new ResourceNotFoundException(string).initCause(e);
            }
        }

        public void init(ExtendedProperties extendedProperties) {
        }

        public boolean isSourceModified(Resource resource) {
            return false;
        }
    }
}

