/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.Parameter;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodVisitor
extends JavaAstVisitor {
    private static final String CONSTRUCTOR = "<init>";
    private static final List<Integer> wantedTokens = Arrays.asList(8, 9);
    private static final Map<Integer, JvmJavaType> tokenJavaTypeMapping = new HashMap<Integer, JvmJavaType>();

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isConstructor = this.isConstructor(ast);
        String methodName = this.buildMethodSignature(ast, isConstructor);
        SourceMethod sourceMethod = new SourceMethod(this.peekParentClass(), methodName, ast.getLineNo());
        sourceMethod.setMeasure((MetricDef)Metric.METHODS, 1);
        if (isConstructor) {
            sourceMethod.setMeasure((MetricDef)Metric.CONSTRUCTORS, 1);
        }
        this.addSourceCode(sourceMethod);
    }

    private boolean isConstructor(DetailAST ast) {
        return ast.getType() == 8;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.popSourceCode();
    }

    private String buildMethodSignature(DetailAST ast, boolean isConstructor) {
        String methodName = this.extractMethodName(ast, isConstructor);
        Parameter returnType = this.extractMethodReturnType(ast, isConstructor);
        List<Parameter> argumentTypes = this.extractMethodArgumentTypes(ast);
        MethodSignature signature = new MethodSignature(methodName, returnType, argumentTypes);
        return MethodSignaturePrinter.print(signature);
    }

    private List<Parameter> extractMethodArgumentTypes(DetailAST ast) {
        ArrayList<Parameter> argumentTypes = new ArrayList<Parameter>();
        for (DetailAST child = ast.findFirstToken(20).findFirstToken(21); child != null; child = (DetailAST)child.getNextSibling()) {
            if (child.getType() != 21) continue;
            Parameter argumentType = this.extractArgumentAndReturnType(child.findFirstToken(13));
            argumentTypes.add(new Parameter(argumentType));
        }
        return argumentTypes;
    }

    private String extractMethodName(DetailAST ast, boolean isConstructor) {
        if (isConstructor) {
            return CONSTRUCTOR;
        }
        return ast.findFirstToken(58).getText();
    }

    private Parameter extractMethodReturnType(DetailAST ast, boolean isConstructor) {
        if (isConstructor) {
            return new Parameter(JvmJavaType.V, false);
        }
        Parameter returnType = this.extractArgumentAndReturnType(ast.findFirstToken(13));
        return new Parameter(returnType);
    }

    private Parameter extractArgumentAndReturnType(DetailAST ast) {
        boolean isArray = this.isArrayType(ast);
        for (Integer tokenType : tokenJavaTypeMapping.keySet()) {
            if (!ast.branchContains(tokenType.intValue())) continue;
            return new Parameter(tokenJavaTypeMapping.get(tokenType), isArray);
        }
        if (this.isObjectType(ast)) {
            String className = isArray ? this.extractClassName(this.drilldownToLastArray(ast)) : this.extractClassName(ast);
            return new Parameter(className, isArray);
        }
        throw new IllegalStateException("No Known TokenType has been found at line " + ast.getLineNo() + " of file " + this.getFileContents().getFilename());
    }

    private DetailAST drilldownToLastArray(DetailAST ast) {
        while (ast.findFirstToken(17) != null) {
            ast = ast.findFirstToken(17);
        }
        return ast;
    }

    private String extractClassName(DetailAST ast) {
        if (ast.findFirstToken(59) != null) {
            return this.findLastToken(ast.findFirstToken(59), 58).getText();
        }
        return this.findLastToken(ast, 58).getText();
    }

    private DetailAST findLastToken(DetailAST astNode, int tokenType) {
        DetailAST retVal = null;
        for (AST child = astNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != tokenType) continue;
            retVal = (DetailAST)child;
        }
        return retVal;
    }

    private boolean isObjectType(DetailAST ast) {
        return ast.branchContains(58);
    }

    private boolean isArrayType(DetailAST ast) {
        return ast.findFirstToken(58) == null && ast.branchContains(17);
    }

    static {
        tokenJavaTypeMapping.put(51, JvmJavaType.B);
        tokenJavaTypeMapping.put(52, JvmJavaType.C);
        tokenJavaTypeMapping.put(53, JvmJavaType.S);
        tokenJavaTypeMapping.put(54, JvmJavaType.I);
        tokenJavaTypeMapping.put(56, JvmJavaType.J);
        tokenJavaTypeMapping.put(50, JvmJavaType.Z);
        tokenJavaTypeMapping.put(55, JvmJavaType.F);
        tokenJavaTypeMapping.put(57, JvmJavaType.D);
        tokenJavaTypeMapping.put(49, JvmJavaType.V);
    }
}

