/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import org.codehaus.plexus.ComponentRegistry;
import org.codehaus.plexus.DefaultComponentRegistry;
import org.codehaus.plexus.component.manager.PerLookupComponentManagerFactory;
import org.codehaus.plexus.component.manager.SingletonComponentManagerFactory;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;
import org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;

public class InitializeComponentRegistryPhase
implements ContainerInitializationPhase {
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        LifecycleHandlerManager lifecycleHandlerManager = this.getLifecycleHandlerManager(context);
        DefaultComponentRegistry componentRegistry = new DefaultComponentRegistry(context.getContainer(), lifecycleHandlerManager);
        componentRegistry.registerComponentManagerFactory(new PerLookupComponentManagerFactory());
        componentRegistry.registerComponentManagerFactory(new SingletonComponentManagerFactory());
        this.initializeComponentRegistry(componentRegistry, context);
        context.getContainer().setComponentRegistry(componentRegistry);
    }

    private void initializeComponentRegistry(ComponentRegistry componentRegistry, ContainerInitializationContext context) throws ContainerInitializationException {
        try {
            PlexusConfiguration[] componentConfigurations;
            PlexusConfiguration configuration = context.getContainerXmlConfiguration();
            for (PlexusConfiguration componentConfiguration : componentConfigurations = configuration.getChild("components").getChildren("component")) {
                ComponentDescriptor<?> componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration, context.getContainer().getContainerRealm());
                if (componentDescriptor == null) continue;
                componentRegistry.addComponentDescriptor(componentDescriptor);
            }
        }
        catch (PlexusConfigurationException e) {
            throw new ContainerInitializationException("Error initializing component repository: Cannot unmarshall component descriptor: ", e);
        }
        catch (ComponentRepositoryException e) {
            throw new ContainerInitializationException("Error initializing component repository: ", e);
        }
    }

    private LifecycleHandlerManager getLifecycleHandlerManager(ContainerInitializationContext context) {
        LifecycleHandlerManager lifecycleHandlerManager = context.getContainerConfiguration().getLifecycleHandlerManager();
        lifecycleHandlerManager.initialize();
        return lifecycleHandlerManager;
    }
}

