/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import com.google.common.base.ReferenceType;
import com.google.common.collect.ReferenceMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptorListener;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveMap<T>
implements ConcurrentMap<String, T> {
    private final MutablePlexusContainer container;
    private final Class<T> type;
    private final List<String> roleHints;
    private final String hostComponent;
    private final ConcurrentMap<String, T> components = new ReferenceMap(ReferenceType.STRONG, ReferenceType.WEAK);
    private final Map<String, T> immutableComponents = Collections.unmodifiableMap(this.components);
    private final ConcurrentMap<ComponentDescriptor<? extends T>, T> componentsByDescriptor = new ReferenceMap(ReferenceType.STRONG, ReferenceType.WEAK);

    public LiveMap(MutablePlexusContainer container, Class<T> type, List<String> roleHints, String hostComponent) {
        this.container = container;
        this.type = type;
        this.roleHints = roleHints == null ? null : Collections.unmodifiableList(new ArrayList<String>(roleHints));
        this.hostComponent = hostComponent;
        container.addComponentDescriptorListener(new LiveMapDescriptorListener());
    }

    public String getHostComponent() {
        return this.hostComponent;
    }

    @Override
    public boolean isEmpty() {
        return this.immutableComponents.isEmpty();
    }

    @Override
    public int size() {
        return this.immutableComponents.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.immutableComponents.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.immutableComponents.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.immutableComponents.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.immutableComponents.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.immutableComponents.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.immutableComponents.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Map && ((Object)this.immutableComponents).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.immutableComponents).hashCode();
    }

    public String toString() {
        return this.immutableComponents.toString();
    }

    @Override
    public T put(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T putIfAbsent(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, T oldValue, T newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T replace(String key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LiveMapDescriptorListener
    implements ComponentDescriptorListener<T> {
        private LiveMapDescriptorListener() {
        }

        @Override
        public Class<T> getType() {
            return LiveMap.this.type;
        }

        @Override
        public List<String> getRoleHints() {
            return LiveMap.this.roleHints;
        }

        @Override
        public synchronized void componentDescriptorAdded(ComponentDescriptor<? extends T> descriptor) {
            String roleHint = descriptor.getRoleHint();
            if (!LiveMap.this.components.containsKey(roleHint) && (LiveMap.this.roleHints == null || LiveMap.this.roleHints.contains(roleHint))) {
                Object component = null;
                try {
                    component = LiveMap.this.container.lookup(descriptor);
                }
                catch (ComponentLookupException ignored) {
                    // empty catch block
                }
                LiveMap.this.components.put(roleHint, component);
                LiveMap.this.componentsByDescriptor.put(descriptor, component);
            }
        }

        @Override
        public synchronized void componentDescriptorRemoved(ComponentDescriptor<? extends T> descriptor) {
            Object component = LiveMap.this.componentsByDescriptor.remove(descriptor);
            if (component != null) {
                LiveMap.this.components.remove(descriptor.getRoleHint(), component);
            }
        }
    }
}

