/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.gleaner.QDoxComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.SourceComponentGleaner;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ComponentDescriptorExtractor.class, hint="source")
public class SourceComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private SourceComponentGleaner gleaner;

    public SourceComponentDescriptorExtractor() {
    }

    public SourceComponentDescriptorExtractor(SourceComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    @Override
    public List<ComponentDescriptor<?>> extract(MetadataGenerationRequest configuration, ComponentDescriptor<?>[] roleDefaults) throws Exception {
        if (this.gleaner == null) {
            this.gleaner = new QDoxComponentGleaner();
        }
        return this.extract(configuration.sourceDirectories, configuration.sourceEncoding, this.getDefaultsByRole(roleDefaults));
    }

    private List<ComponentDescriptor<?>> extract(List<String> sourceDirectories, String sourceEncoding, Map<String, ComponentDescriptor<?>> defaultsByRole) throws Exception {
        assert (sourceDirectories != null);
        assert (defaultsByRole != null);
        ArrayList descriptors = new ArrayList();
        JavaProjectBuilder builder = new JavaProjectBuilder();
        if (StringUtils.isNotEmpty((String)sourceEncoding)) {
            builder.setEncoding(sourceEncoding);
        }
        for (String sourceDirectory : sourceDirectories) {
            File dir = new File(sourceDirectory);
            builder.addSourceTree(dir);
        }
        Collection classes = builder.getClasses();
        for (JavaClass aClass : classes) {
            ComponentDescriptor<?> descriptor = this.gleaner.glean(builder, aClass);
            if (descriptor == null) continue;
            this.applyDefaults(descriptor, defaultsByRole);
            descriptors.add(descriptor);
        }
        return descriptors;
    }
}

