/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.gleaner.AnnotationComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.ClassComponentGleaner;
import org.codehaus.plexus.util.DirectoryScanner;

@Component(role=ComponentDescriptorExtractor.class, hint="class")
public class ClassComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private ClassComponentGleaner gleaner;

    public ClassComponentDescriptorExtractor(ClassComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    public ClassComponentDescriptorExtractor() {
        this.gleaner = new AnnotationComponentGleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentDescriptor<?>> extract(MetadataGenerationRequest configuration, ComponentDescriptor<?>[] roleDefaults) throws Exception {
        if (this.gleaner == null) {
            throw new IllegalStateException("Gleaner is not bound");
        }
        if (!configuration.classesDirectory.exists()) {
            return Collections.emptyList();
        }
        if (configuration.useContextClassLoader) {
            return this.extract(configuration.classesDirectory, Thread.currentThread().getContextClassLoader(), this.getDefaultsByRole(roleDefaults));
        }
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = this.createClassLoader(configuration.classpath);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            List<ComponentDescriptor<?>> list = this.extract(configuration.classesDirectory, cl, this.getDefaultsByRole(roleDefaults));
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    private ClassLoader createClassLoader(List<String> elements) throws Exception {
        URL[] urls;
        ArrayList<URL> list = new ArrayList<URL>();
        for (String filename : elements) {
            try {
                list.add(new File(filename).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid classpath entry: " + filename, (Exception)e);
            }
        }
        for (URL url : urls = list.toArray(new URL[list.size()])) {
        }
        return new URLClassLoader(urls, null);
    }

    private List<ComponentDescriptor<?>> extract(File classesDir, ClassLoader cl, Map<String, ComponentDescriptor<?>> defaultsByRole) throws Exception {
        String[] includes;
        assert (classesDir != null);
        assert (cl != null);
        assert (defaultsByRole != null);
        ArrayList descriptors = new ArrayList();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classesDir);
        scanner.addDefaultExcludes();
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        for (String include : includes = scanner.getIncludedFiles()) {
            String className = include.substring(0, include.lastIndexOf(".class")).replace('\\', '.').replace('/', '.');
            try {
                ComponentDescriptor<?> descriptor = this.gleaner.glean(className, cl);
                if (descriptor == null) continue;
                this.applyDefaults(descriptor, defaultsByRole);
                descriptors.add(descriptor);
            }
            catch (VerifyError e) {
                // empty catch block
            }
        }
        return descriptors;
    }
}

