/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.mojo.webstart.Pack200Tool;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.task.AbstractJnlpTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTaskException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="UnPack200Task", instantiationStrategy="per-lookup")
public class UnPack200Task
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "UnPack200Task";
    @Requirement(role=Pack200Tool.class)
    private List<Pack200Tool> pack200Tools;

    public void check(JnlpDependencyConfig config) {
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isPack200()) {
            throw new IllegalStateException("Can't pack200 if config.isPack200 is false");
        }
    }

    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        this.verboseLog(config, "Unpack 200 file: " + file);
        try {
            File result = this.getPack200Tool().unpackJar(file);
            this.getLogger().debug("Unpacked 200 file: " + result);
            return result;
        }
        catch (IOException e) {
            throw new JnlpDependencyTaskException("Could not pack200 jars: ", e);
        }
    }

    protected Pack200Tool getPack200Tool() {
        return this.pack200Tools.get(0);
    }
}

