/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.ArtifactVersions;

public class PluginUpdatesDetails
extends ArtifactVersions {
    private final Map<Dependency, ArtifactVersions> dependencyVersions;
    private final boolean includeSnapshots;

    public PluginUpdatesDetails(ArtifactVersions artifactVersions, Map<Dependency, ArtifactVersions> dependencyVersions, boolean includeSnapshots) {
        super(artifactVersions);
        Objects.requireNonNull(artifactVersions);
        Objects.requireNonNull(dependencyVersions);
        this.dependencyVersions = dependencyVersions;
        this.includeSnapshots = includeSnapshots;
    }

    public Map<Dependency, ArtifactVersions> getDependencyVersions() {
        return this.dependencyVersions;
    }

    public boolean isArtifactUpdateAvailable() {
        ArtifactVersion[] updates = this.getAllUpdates(Optional.empty(), this.includeSnapshots);
        return updates != null && updates.length > 0;
    }

    public boolean isDependencyUpdateAvailable() {
        return this.dependencyVersions.values().stream().anyMatch(versions -> {
            ArtifactVersion[] dependencyUpdates = versions.getAllUpdates(Optional.empty(), this.includeSnapshots);
            return dependencyUpdates != null && dependencyUpdates.length > 0;
        });
    }

    public boolean isUpdateAvailable() {
        return this.isArtifactUpdateAvailable() || this.isDependencyUpdateAvailable();
    }
}

