/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.VersionsReportRendererBase;
import org.codehaus.mojo.versions.reporting.util.ReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractVersionsReportRenderer<T>
extends VersionsReportRendererBase
implements ReportRenderer {
    protected T model;
    protected final ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getReportNewestUpdate);
    protected final ArtifactVersionsCache allUpdatesCache = new ArtifactVersionsCache(AbstractVersionDetails::getReportUpdates);
    protected final SinkEventAttributes headerAttributes = new SinkEventAttributeSet(new String[]{"width", "30%"});

    protected AbstractVersionsReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, T model, boolean allowSnapshots) {
        super(sink, i18n, locale, bundleName, allowSnapshots);
        this.model = model;
    }

    protected void renderBody() {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.paragraph_();
        this.renderOverview();
        this.renderManagementSummaryTable();
        this.renderSummaryTable();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.detail.title"));
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getText("report.detail.text"));
        this.sink.paragraph_();
        this.renderDetails();
        this.sink.section1_();
    }

    protected void renderOverview() {
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.renderOverviewTableRow(this.computeOverviewStats());
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected abstract void renderManagementSummaryTable();

    protected abstract void renderSummaryTable();

    protected <Q extends OverviewStats> void renderOverviewTableRow(Q stats) {
        this.renderStatRow("report.overview.numUpToDate", stats.getUpToDate(), true);
        this.renderStatRow("report.overview.numNewerVersionAvailable", stats.getAny(), false);
        this.renderStatRow("report.overview.numNewerIncrementalAvailable", stats.getIncremental(), false);
        this.renderStatRow("report.overview.numNewerMinorAvailable", stats.getMinor(), false);
        this.renderStatRow("report.overview.numNewerMajorAvailable", stats.getMajor(), false);
    }

    protected void renderStatRow(String textKey, int statCount, boolean forceSuccessIcon) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderIcon(statCount == 0 || forceSuccessIcon);
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(this.getText(textKey));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(statCount));
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderIcon(boolean success) {
        if (success) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
    }

    protected abstract <Q extends OverviewStats> Q computeOverviewStats();

    protected abstract void renderDetails();

    protected void renderSummaryTable(Map<Dependency, ArtifactVersions> contents, boolean hasScope) {
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.renderSummaryTableHeader(hasScope, true);
        this.sink.tableRow_();
        contents.forEach((artifact, artifactVersions) -> this.renderSummaryTableRow((Dependency)artifact, (ArtifactVersions)artifactVersions, hasScope));
        this.sink.tableRow();
        this.renderSummaryTableHeader(hasScope, true);
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        this.renderTableHeaderCells("report.status", "report.groupId", "report.artifactId", "report.currentVersion");
        if (hasScope) {
            this.renderTableHeaderCells("report.scope");
        }
        if (hasType) {
            this.renderTableHeaderCells("report.classifier", "report.type");
        }
        this.renderTableHeaderCells("report.latestSubIncremental", "report.latestIncremental", "report.latestMinor", "report.latestMajor");
    }

    protected void renderSummaryTableRow(Dependency artifact, ArtifactVersions details, boolean includeScope) {
        details.setCurrentVersion(artifact.getVersion());
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get((AbstractVersionDetails)details, Optional.empty(), this.isAllowSnapshots());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderIcon(upToDate);
        this.sink.tableCell_();
        this.renderCells(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (includeScope) {
            this.renderCell(artifact.getScope());
        }
        this.renderCells(artifact.getClassifier(), artifact.getType());
        this.renderNewestVersions((AbstractVersionDetails)details);
        this.sink.tableRow_();
    }

    protected void renderNewestVersions(AbstractVersionDetails details) {
        this.renderBoldCell(this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL), this.isAllowSnapshots()));
        this.renderBoldCell(this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL), this.isAllowSnapshots()));
        this.renderBoldCell(this.newestUpdateCache.get(details, Optional.of(Segment.MINOR), this.isAllowSnapshots()));
        this.renderBoldCell(this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR), this.isAllowSnapshots()));
    }

    protected void renderDependencyDetailTable(Dependency artifact, ArtifactVersions details, boolean includeScope) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get((AbstractVersionDetails)details, Optional.empty(), this.isAllowSnapshots());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.renderTwoCellsRow("report.status", () -> this.renderStatus((AbstractVersionDetails)details));
        this.renderTwoCellsRow("report.groupId", artifact.getGroupId());
        this.renderTwoCellsRow("report.artifactId", artifact.getArtifactId());
        this.renderTwoCellsRow("report.currentVersion", artifact.getVersion());
        if (includeScope) {
            this.renderTwoCellsRow("report.scope", artifact.getScope());
        }
        this.renderTwoCellsRow("report.classifier", artifact.getClassifier());
        this.renderTwoCellsRow("report.type", artifact.getType());
        if (!upToDate) {
            this.renderTwoCellsRow("report.updateVersions", () -> this.renderVersions(allUpdates, (AbstractVersionDetails)details));
        }
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected void renderTwoCellsRow(String textKey, String textValue) {
        this.sink.tableRow();
        this.sink.tableHeaderCell(this.headerAttributes);
        this.sink.text(this.getText(textKey));
        this.sink.tableHeaderCell_();
        this.sink.tableCell();
        this.sink.text(textValue);
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderTwoCellsRow(String textKey, Runnable runnable) {
        this.sink.tableRow();
        this.sink.tableHeaderCell(this.headerAttributes);
        this.sink.text(this.getText(textKey));
        this.sink.tableHeaderCell_();
        this.sink.tableCell();
        runnable.run();
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderStatus(AbstractVersionDetails details) {
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL), this.isAllowSnapshots()) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL), this.isAllowSnapshots()) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR), this.isAllowSnapshots()) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR), this.isAllowSnapshots()) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
    }

    private List<Restriction> getArtifactVersionRange(AbstractVersionDetails details) {
        try {
            String spec = details.getCurrentVersion().toString();
            VersionRange range = VersionRange.createFromVersionSpec((String)spec);
            return range.getRestrictions();
        }
        catch (InvalidVersionSpecificationException ignored) {
            ignored.printStackTrace(System.err);
            return Collections.EMPTY_LIST;
        }
    }

    protected void renderVersions(ArtifactVersion[] allUpdates, AbstractVersionDetails details) {
        List<Restriction> versionRange = this.getArtifactVersionRange(details);
        boolean someNotAllowed = false;
        for (int i = 0; i < allUpdates.length; ++i) {
            if (i > 0) {
                this.sink.lineBreak();
            }
            ArtifactVersion candidate = allUpdates[i];
            boolean allowed = versionRange.stream().anyMatch(restriction -> details.isVersionInRestriction(restriction, candidate));
            String label = this.getLabel(allUpdates[i], details);
            if (!allowed) {
                this.sink.text("* ");
                someNotAllowed = true;
            }
            if (allowed && label != null) {
                this.sink.bold();
            }
            this.sink.text(allUpdates[i].toString());
            if (label == null) continue;
            if (allowed) {
                this.sink.bold_();
            }
            this.sink.nonBreakingSpace();
            this.sink.italic();
            this.sink.text(label);
            this.sink.italic_();
        }
        if (someNotAllowed) {
            this.sink.lineBreak();
            this.sink.lineBreak();
            this.sink.text("* ");
            this.sink.italic();
            this.sink.text(this.getText("report.excludedVersion"));
            this.sink.italic_();
        }
    }

    protected String getLabel(ArtifactVersion version, AbstractVersionDetails details) {
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL), this.isAllowSnapshots()))) {
            return this.getText("report.latestSubIncremental");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL), this.isAllowSnapshots()))) {
            return this.getText("report.latestIncremental");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.MINOR), this.isAllowSnapshots()))) {
            return this.getText("report.latestMinor");
        }
        if (this.equals(version, (ArtifactVersion)this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR), this.isAllowSnapshots()))) {
            return this.getText("report.latestMajor");
        }
        return null;
    }
}

