/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected MavenProjectBuilder projectBuilder;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List reactorProjects;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remotePluginRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    private WagonManager wagonManager;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    private String serverId;
    @Parameter(property="maven.version.rules")
    private String rulesUri;
    @Parameter(property="generateBackupPoms", defaultValue="true")
    private boolean generateBackupPoms;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    protected PathTranslator pathTranslator;
    @Component
    protected ArtifactResolver artifactResolver;

    public VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper(this.artifactFactory, this.artifactResolver, this.artifactMetadataSource, this.remoteArtifactRepositories, this.remotePluginRepositories, this.localRepository, this.wagonManager, this.settings, this.serverId, this.rulesUri, this.getLog(), this.session, this.pathTranslator);
        }
        return this.helper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getVersion() {
        return this.getProject() == null ? null : this.getProject().getVersion();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, MojoExecutionException {
        boolean includeSnapshots = this.allowSnapshots;
        if (Boolean.TRUE.equals(allowingSnapshots)) {
            includeSnapshots = true;
        }
        if (Boolean.FALSE.equals(allowingSnapshots)) {
            includeSnapshots = false;
        }
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, usePluginRepositories);
        return artifactVersions.getNewestVersion(versionRange, includeSnapshots);
    }

    protected String getPropertyValue(StringBuilder pom, String property) {
        return this.project.getProperties().getProperty(property);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder input = PomHelper.readXmlFile(outFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input, outFile.getAbsolutePath());
            this.update(newPom);
            if (newPom.isModified()) {
                if (this.generateBackupPoms) {
                    File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
                    if (!backupFile.exists()) {
                        this.getLog().debug((CharSequence)("Backing up " + outFile + " to " + backupFile));
                        FileUtils.copyFile((File)outFile, (File)backupFile);
                    } else {
                        this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                    }
                } else {
                    this.getLog().debug((CharSequence)"Skipping generation of backup file");
                }
                this.writeFile(outFile, input);
            }
        }
        catch (IOException | XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuilder input, String path) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory, path);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    protected final void writeFile(File outFile, StringBuilder input) throws IOException {
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outFile);){
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
    }

    protected abstract void update(ModifiedPomXMLEventReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException;

    @Deprecated
    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        return this.shouldApplyUpdate(artifact, currentVersion, updateVersion, false);
    }

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion, boolean forceUpdate) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (forceUpdate) {
            this.getLog().info((CharSequence)"Force update enabled. LATEST or RELEASE versions will be overwritten with real version");
            return true;
        }
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.resolver.resolveAlways(artifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact), (Throwable)e);
            return false;
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not find " + artifact), (Throwable)e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact + " is the latest."));
            return false;
        }
        return true;
    }

    protected int determineUnchangedSegment(boolean allowMajorUpdates, boolean allowMinorUpdates, boolean allowIncrementalUpdates) {
        int segment;
        if (allowMajorUpdates) {
            segment = -1;
            this.getLog().info((CharSequence)"Major version changes allowed");
        } else if (allowMinorUpdates) {
            segment = 0;
            this.getLog().info((CharSequence)"Minor version changes allowed");
        } else if (allowIncrementalUpdates) {
            segment = 1;
            this.getLog().info((CharSequence)"Incremental version changes allowed");
        } else {
            segment = 2;
            this.getLog().info((CharSequence)"Subincremental version changes allowed");
        }
        return segment;
    }

    protected void updatePropertyToNewestVersion(ModifiedPomXMLEventReader pom, Property property, PropertyVersions version, String currentVersion) throws MojoExecutionException, XMLStreamException {
        this.updatePropertyToNewestVersion(pom, property, version, currentVersion, false, -1);
    }

    protected void updatePropertyToNewestVersion(ModifiedPomXMLEventReader pom, Property property, PropertyVersions version, String currentVersion, boolean allowDowngrade, int segment) throws MojoExecutionException, XMLStreamException {
        ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper(), allowDowngrade, segment);
        if (winner == null || currentVersion.equals(winner.toString())) {
            this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion));
        } else if (PomHelper.setPropertyVersion(pom, version.getProfileId(), property.getName(), winner.toString())) {
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
        }
    }
}

