/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.smc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.smc.Util;

public class SmcMojo
extends AbstractMojo {
    private MavenProject project;
    private File sourceDirectory;
    private File outputDirectory;
    private boolean fork;
    private boolean failOnError;
    private boolean debug;
    private boolean verbose;
    private boolean sync;

    public void execute() throws MojoExecutionException {
        List files;
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("sourceDirectory " + this.sourceDirectory + " doesn't exist."));
            return;
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException("sourceDirectory " + this.sourceDirectory + " isn't a directory");
        }
        try {
            files = Util.getSmFiles(this.sourceDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't find the .sm files in " + this.sourceDirectory, (Exception)e);
        }
        this.getLog().debug((CharSequence)("Found " + files.size() + " .sm file(s) to process."));
        for (int i = 0; i < files.size(); ++i) {
            File theOutputDirectory;
            File smFile = (File)files.get(i);
            this.getLog().debug((CharSequence)("Handling " + smFile));
            String classPackage = null;
            String theClass = null;
            try {
                Properties properties = Util.getSmFileHeader(smFile);
                classPackage = properties.getProperty("package");
                theClass = properties.getProperty("class");
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Couldn't identify the package for file " + smFile.getAbsolutePath()), (Throwable)e);
            }
            if (classPackage != null) {
                classPackage = classPackage.replace(".", File.separator);
            }
            if (!(theOutputDirectory = new File(this.outputDirectory + File.separator + classPackage)).exists() && !theOutputDirectory.mkdirs()) {
                this.getLog().warn((CharSequence)("the destination directory (" + theOutputDirectory + ") for file " + smFile.getAbsolutePath() + "  doesn't exist and couldn't be created. The goal with probably fail."));
            }
            if (theClass != null) {
                File file = new File(theOutputDirectory, theClass + "Context.java");
                if (file.exists() && file.lastModified() > smFile.lastModified()) {
                    this.getLog().debug((CharSequence)("Skipping regeneration of " + file + " as it is newer than " + smFile));
                    continue;
                }
            } else {
                this.getLog().warn((CharSequence)"Didn't identify the %class from the .sm file");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("-ret");
            arguments.add("-d");
            arguments.add(theOutputDirectory.getAbsolutePath());
            if (this.sync) {
                arguments.add("-sync");
            }
            if (this.verbose) {
                arguments.add("-verbose");
            }
            arguments.add("-java");
            arguments.add(smFile.getAbsolutePath());
            this.executeSmc(arguments);
        }
        this.getLog().debug((CharSequence)("Adding outputDirectory to source root: " + this.outputDirectory));
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private void executeSmc(List arguments) throws MojoExecutionException {
        try {
            Util.executeSmc(arguments, this.getLog());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure to execute Smc", e);
        }
    }
}

