/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.rpm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.mojo.tools.rpm.RpmEvalException;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmQueryException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RpmMediator
implements LogEnabled {
    public static final String ROLE = RpmMediator.class.getName();
    private CommandLineManager cliManager;
    private boolean useSudo = true;
    private Boolean noParentDirs = false;
    private Map<String, Boolean> rpmPresenceQueryResults = new HashMap<String, Boolean>();
    private Logger logger;

    public RpmMediator() {
    }

    public RpmMediator(CommandLineManager cliManager) {
        this.cliManager = cliManager;
    }

    public void setUseSudo(boolean useSudo) {
        this.useSudo = useSudo;
    }

    public void setNoParentDirs(boolean noParentDirs) {
        this.noParentDirs = noParentDirs;
    }

    public void install(String rpmPackage, File rpmFile, boolean force) throws RpmInstallException {
        this.install(rpmPackage, rpmFile, null, force);
    }

    public void install(String rpmPackage, File rpmFile, String rpmDbPath, boolean force) throws RpmInstallException {
        this.getLogger().debug("Installing RPM: " + rpmPackage);
        Commandline cmdLine = new Commandline();
        if (this.useSudo) {
            cmdLine.setExecutable("sudo");
            cmdLine.createArg().setLine("rpm");
        } else {
            cmdLine.setExecutable("rpm");
        }
        cmdLine.createArg().setLine("-Uh");
        if (force) {
            cmdLine.createArg().setLine("--force");
            cmdLine.createArg().setLine("--nodeps");
        }
        File gentooFile = new File("/etc/gentoo-release");
        if (this.noParentDirs.booleanValue() || gentooFile.exists()) {
            cmdLine.createArg().setLine("--noparentdirs");
        }
        cmdLine.createArg().setLine(StringUtils.quoteAndEscape((String)rpmFile.getAbsolutePath(), (char)'\u0000'));
        if (rpmDbPath != null && rpmDbPath.trim().length() > 0) {
            cmdLine.createArg().setLine("--dbpath");
            cmdLine.createArg().setLine(rpmDbPath);
            this.getLogger().debug("RPM DB Path is set to: '" + rpmDbPath + "'");
        } else {
            this.getLogger().debug("RPM DB Path is not set.");
        }
        this.getLogger().debug("Executing command:\n\t\t" + cmdLine);
        try {
            StreamConsumer consumer = this.cliManager.newInfoStreamConsumer();
            int exitValue = this.cliManager.execute(cmdLine, consumer, consumer);
            if (exitValue != 0) {
                throw new RpmInstallException("RPM installation process exited abnormally (returned: " + exitValue + ").");
            }
            this.rpmPresenceQueryResults.put(rpmPackage, Boolean.TRUE);
        }
        catch (CommandLineException e) {
            throw new RpmInstallException("Error executing RPM installation.", e);
        }
    }

    public void remove(String rpmPackage) throws RpmInstallException {
        this.remove(rpmPackage, null);
    }

    public void remove(String rpmPackage, String rpmDbPath) throws RpmInstallException {
        boolean isInstalled;
        this.getLogger().debug("Attempting to remove: " + rpmPackage);
        try {
            isInstalled = this.isRpmInstalled(rpmPackage, rpmDbPath);
        }
        catch (RpmQueryException e) {
            throw new RpmInstallException("Error checking for RPM presence. Error was: " + e.getMessage(), e);
        }
        if (isInstalled) {
            Commandline cmdLine = new Commandline();
            if (this.useSudo) {
                cmdLine.setExecutable("sudo");
                cmdLine.createArg().setLine("rpm");
            } else {
                cmdLine.setExecutable("rpm");
            }
            cmdLine.createArg().setLine("-e");
            cmdLine.createArg().setLine("--allmatches");
            cmdLine.createArg().setLine(rpmPackage);
            if (rpmDbPath != null && rpmDbPath.trim().length() > 0) {
                cmdLine.createArg().setLine("--dbpath");
                cmdLine.createArg().setLine(rpmDbPath);
                this.getLogger().debug("RPM DB Path is set to: '" + rpmDbPath + "'");
            } else {
                this.getLogger().debug("RPM DB Path is not set.");
            }
            try {
                StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
                int exitValue = this.cliManager.execute(cmdLine, consumer, consumer);
                if (exitValue != 0) {
                    throw new RpmInstallException("RPM removal process exited abnormally (returned: " + exitValue + ").");
                }
                this.rpmPresenceQueryResults.put(rpmPackage, Boolean.FALSE);
            }
            catch (CommandLineException e) {
                throw new RpmInstallException("Error executing RPM removal.", e);
            }
            this.getLogger().debug("Removed RPM: " + rpmPackage);
        } else {
            this.getLogger().debug("RPM: " + rpmPackage + " is not installed. Skipping removal.");
        }
    }

    public boolean isRpmInstalled(String rpmPackage) throws RpmQueryException {
        return this.isRpmInstalled(rpmPackage, null);
    }

    public boolean isRpmInstalled(String rpmPackage, String rpmDbPath) throws RpmQueryException {
        return this.isRpmInstalled(rpmPackage, null, rpmDbPath);
    }

    public boolean isRpmInstalled(String rpmPackage, String version, String rpmDbPath) throws RpmQueryException {
        return this.isRpmInstalled(rpmPackage, version, null, rpmDbPath);
    }

    public boolean isRpmInstalled(String rpmPackage, String version, String release, String rpmDbPath) throws RpmQueryException {
        boolean result = false;
        if (version != null && version.trim().length() > 0) {
            rpmPackage = rpmPackage + "-" + version;
        }
        this.getLogger().debug("rpmPackage='" + rpmPackage + "'");
        Boolean cached = this.rpmPresenceQueryResults.get(rpmPackage);
        if (cached != null) {
            result = cached;
        } else {
            Commandline cmdLine = new Commandline();
            cmdLine.setExecutable("rpm");
            cmdLine.createArg().setLine("-q");
            cmdLine.createArg().setLine(rpmPackage);
            if (rpmDbPath != null && rpmDbPath.trim().length() > 0) {
                cmdLine.createArg().setLine("--dbpath");
                cmdLine.createArg().setLine(rpmDbPath);
                this.getLogger().debug("RPM DB Path is set to: '" + rpmDbPath + "'");
            } else {
                this.getLogger().debug("RPM DB Path is not set.");
            }
            try {
                StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
                int exitValue = this.cliManager.execute(cmdLine, consumer, consumer);
                boolean bl = result = exitValue == 0;
                if (result && release != null) {
                    cmdLine.createArg().setLine("--queryformat");
                    cmdLine.createArg().setLine("%{RELEASE}");
                    CommandLineUtils.StringStreamConsumer stdoutConsumer = new CommandLineUtils.StringStreamConsumer();
                    exitValue = this.cliManager.execute(cmdLine, (StreamConsumer)stdoutConsumer, consumer);
                    String myRel = stdoutConsumer.getOutput().trim();
                    if (myRel.length() > 0 && Character.isDigit(myRel.charAt(0))) {
                        int rpmRelease = myRel.indexOf(46) > 0 ? Integer.parseInt(myRel.substring(0, myRel.indexOf(46))) : Integer.parseInt(myRel);
                        if (exitValue == 0 && Integer.parseInt(release) > rpmRelease) {
                            this.getLogger().info("RPM: " + rpmPackage + " can upgrade from release " + rpmRelease + " to " + release);
                            result = false;
                            return result;
                        }
                        this.getLogger().debug("RPM: " + rpmPackage + " found release " + rpmRelease + " and will not install release " + release);
                    }
                }
                this.rpmPresenceQueryResults.put(rpmPackage, result);
            }
            catch (CommandLineException e) {
                throw new RpmQueryException("Error executing RPM query.", e);
            }
        }
        this.getLogger().info("RPM: " + rpmPackage + (result ? " is installed." : " is NOT installed."));
        return result;
    }

    public String eval(String expression) throws RpmEvalException {
        String result = null;
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable("rpm");
        cmdLine.createArg().setLine("--eval \"%{" + expression + "}\"");
        try {
            CommandLineUtils.StringStreamConsumer consumer = new CommandLineUtils.StringStreamConsumer();
            int exitValue = this.cliManager.execute(cmdLine, (StreamConsumer)consumer, this.cliManager.newDebugStreamConsumer());
            if (exitValue != 0) {
                throw new RpmEvalException("RPM evaluation exited abnormally for expression: " + expression + "(returned: " + exitValue + ").");
            }
            result = consumer.getOutput().trim();
        }
        catch (CommandLineException e) {
            throw new RpmEvalException("Error evaluating RPM expression: " + expression, e);
        }
        return result;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "RpmMediator:internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }
}

