/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.platform;

import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.SystemDistributionDetector;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class WindowsSyspropDistributionDetector
implements SystemDistributionDetector,
LogEnabled {
    public static final String ROLE_HINT = "windows-sysprop";
    private Logger logger;

    public String getDistributionInfo() throws PlatformDetectionException {
        try {
            return "Windows release " + System.getProperty("os.version");
        }
        catch (SecurityException e) {
            throw new PlatformDetectionException("Failed to get OS version property.");
        }
    }

    public String getDistributionInfoSource() throws PlatformDetectionException {
        return "os.name";
    }

    public boolean isEnabled() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.equals("nt") || os.indexOf("windows") > -1;
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

