/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.rpm.RpmConstants;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmMediator;

public class RemoveRpmMojo
extends AbstractMojo {
    private boolean useSudo;
    private boolean skipRemove;
    private List<MavenProject> projects;
    private MavenProject project;
    private static boolean completed = false;
    private String rpmDbPath;
    private RpmInfoFormatter rpmInfoFormatter;
    private RpmMediator rpmMediator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.rpmMediator.setUseSudo(this.useSudo);
        if (this.skipRemove) {
            this.getLog().info((CharSequence)"Skipping RPM removal (per configuration).");
            return;
        }
        if (completed) {
            this.getLog().info((CharSequence)"RPM erase has completed. Skipping this invocation.");
            return;
        }
        if (this.projects != null && !this.projects.isEmpty()) {
            this.getLog().info((CharSequence)("Removing " + this.projects.size() + " project RPMs."));
            ArrayList<MavenProject> projectsInReverseOrder = new ArrayList<MavenProject>(this.projects);
            Collections.reverse(projectsInReverseOrder);
            for (MavenProject tmpProject : projectsInReverseOrder) {
                if (!RpmConstants.RPM_PACKAGINGS.contains(tmpProject.getPackaging())) continue;
                this.removeRPM(tmpProject);
            }
        } else {
            this.getLog().info((CharSequence)"Removing single project RPM.");
            this.removeRPM(this.project);
        }
        completed = true;
    }

    private void removeRPM(MavenProject project) throws MojoExecutionException {
        String rpmBaseName;
        this.getLog().info((CharSequence)("Removing: " + project.getId()));
        try {
            rpmBaseName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)e);
        }
        try {
            this.rpmMediator.remove(rpmBaseName, this.rpmDbPath);
        }
        catch (RpmInstallException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + project, (Exception)e);
        }
    }
}

