/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jsimport.ECMAScriptLexer;
import org.codehaus.mojo.jsimport.FileCollector;
import org.codehaus.mojo.jsimport.FileDependencyPersistanceUtil;
import org.codehaus.mojo.jsimport.JsFileArtifactHandler;
import org.codehaus.mojo.jsimport.LocalRepositoryCollector;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImportMojo
extends AbstractMojo {
    private MavenProject project;
    private List<Dependency> dependencies;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private List<String> includes;
    private List<String> excludes;
    private boolean assumeABrowser;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private ArtifactResolver resolver;
    private final Map<String, String> fileAssignedGlobals = new HashMap<String, String>();
    private final Map<String, String> compileFileAssignedGlobals = new HashMap<String, String>();
    private final Map<String, Set<String>> fileUnassignedGlobals = new HashMap<String, Set<String>>();
    private final Map<String, LinkedHashSet<String>> fileDependencies = new HashMap<String, LinkedHashSet<String>>();
    private BuildContext buildContext;

    private boolean buildDependencyGraphForChangedSourceFiles(long fileDependencyGraphModificationTime, File sourceJsFolder, File targetFolder, LinkedHashSet<File> processedFiles) throws MojoExecutionException {
        File targetJsFolder = new File(targetFolder, "js");
        boolean fileDependencyGraphUpdated = false;
        FileCollector fileCollector = new FileCollector(this.buildContext, new String[]{"**/*.js"}, new String[0]);
        for (String source : fileCollector.collectPaths(sourceJsFolder, this.includes, this.excludes)) {
            File sourceFile = new File(sourceJsFolder, source);
            if (!this.processFileForImportsAndSymbols(sourceJsFolder, targetJsFolder, sourceFile, fileDependencyGraphModificationTime, null)) continue;
            processedFiles.add(sourceFile);
            this.getLog().info((CharSequence)("Processed: " + source));
            fileDependencyGraphUpdated = true;
        }
        return fileDependencyGraphUpdated;
    }

    private boolean buildDependencyGraphForDependencies(Scope scope, long fileDependencyGraphModificationTime, LinkedHashSet<File> processedFiles, File targetFolder, File workFolder, File compileWorkFolder) throws MojoExecutionException {
        File targetJsFolder = new File(targetFolder, "js");
        boolean fileDependencyGraphUpdated = false;
        String scopeStr = scope == Scope.COMPILE ? "compile" : "test";
        AndArtifactFilter jsArtifactFilter = new AndArtifactFilter();
        jsArtifactFilter.add((ArtifactFilter)new ScopeArtifactFilter(scopeStr));
        jsArtifactFilter.add((ArtifactFilter)new TypeArtifactFilter("js"));
        AndArtifactFilter wwwZipArtifactFilter = new AndArtifactFilter();
        wwwZipArtifactFilter.add((ArtifactFilter)new ScopeArtifactFilter(scopeStr));
        wwwZipArtifactFilter.add((ArtifactFilter)new TypeArtifactFilter("zip"));
        wwwZipArtifactFilter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return artifact.hasClassifier() && artifact.getClassifier().equals("www");
            }
        });
        HashMap directArtifactWithTransitives = new HashMap(this.dependencies.size());
        HashSet<Artifact> directArtifacts = new HashSet<Artifact>(this.dependencies.size());
        LinkedHashSet transitiveArtifacts = new LinkedHashSet();
        for (Dependency dependency : this.dependencies) {
            ArtifactResolutionResult result;
            Artifact directArtifact = this.artifactFactory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope());
            if (!jsArtifactFilter.include(directArtifact) && !wwwZipArtifactFilter.include(directArtifact)) continue;
            HashSet<Artifact> artifactsToResolve = new HashSet<Artifact>(1);
            artifactsToResolve.add(directArtifact);
            try {
                result = this.resolver.resolveTransitively(artifactsToResolve, this.project.getArtifact(), this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Problem resolving dependencies", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Problem resolving dependencies", (Exception)((Object)e));
            }
            LinkedHashSet<Artifact> directTransitiveArtifacts = new LinkedHashSet<Artifact>(result.getArtifacts().size());
            for (Object o : result.getArtifacts()) {
                Artifact resolvedArtifact = (Artifact)o;
                if (!jsArtifactFilter.include(resolvedArtifact) || resolvedArtifact.equals(directArtifact)) continue;
                directTransitiveArtifacts.add(resolvedArtifact);
            }
            directArtifacts.add(directArtifact);
            transitiveArtifacts.addAll(directTransitiveArtifacts);
            directArtifactWithTransitives.put(directArtifact, directTransitiveArtifacts);
        }
        HashSet<Artifact> collectedArtifacts = new HashSet<Artifact>(directArtifacts.size() + transitiveArtifacts.size());
        HashMap<ArtifactId, Artifact> indexedCollectedDependencies = new HashMap<ArtifactId, Artifact>(collectedArtifacts.size());
        try {
            LinkedHashSet collectableArtifacts = new LinkedHashSet(directArtifacts);
            collectableArtifacts.addAll(transitiveArtifacts);
            ArtifactResolutionResult resolutionResult = this.artifactCollector.collect(collectableArtifacts, this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null, Collections.EMPTY_LIST);
            for (Object o : resolutionResult.getArtifacts()) {
                Artifact collectedArtifact = (Artifact)o;
                collectedArtifacts.add(collectedArtifact);
                ArtifactId collectedArtifactId = new ArtifactId(collectedArtifact.getGroupId(), collectedArtifact.getArtifactId());
                indexedCollectedDependencies.put(collectedArtifactId, collectedArtifact);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Dependencies collected: " + ((Object)collectedArtifacts).toString()));
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Cannot collect dependencies", (Exception)((Object)e));
        }
        LocalRepositoryCollector localRepositoryCollector = new LocalRepositoryCollector(this.project, this.localRepository, new File[0]);
        for (Map.Entry entry : directArtifactWithTransitives.entrySet()) {
            Artifact directArtifact = (Artifact)entry.getKey();
            LinkedHashSet directArtifactTransitives = (LinkedHashSet)entry.getValue();
            LinkedHashSet<String> transitivesAsImports = new LinkedHashSet<String>(directArtifactTransitives.size());
            Iterator i$ = directArtifactTransitives.iterator();
            while (i$.hasNext()) {
                Artifact o;
                Artifact directTransitiveArtifact = o = (Artifact)i$.next();
                ArtifactId directTransitiveArtifactId = new ArtifactId(directTransitiveArtifact.getGroupId(), directTransitiveArtifact.getArtifactId());
                Artifact transitiveArtifact = (Artifact)indexedCollectedDependencies.get(directTransitiveArtifactId);
                List<File> transitiveArtifactFiles = this.getArtifactFiles(transitiveArtifact, targetFolder, workFolder, compileWorkFolder, localRepositoryCollector);
                for (File transitiveArtifactFile : transitiveArtifactFiles) {
                    if (!processedFiles.contains(transitiveArtifactFile)) {
                        String localRepository = localRepositoryCollector.findLocalRepository(transitiveArtifactFile.getAbsolutePath());
                        if (localRepository != null) {
                            if (this.processFileForImportsAndSymbols(new File(localRepository), targetJsFolder, transitiveArtifactFile, fileDependencyGraphModificationTime, directArtifactTransitives)) {
                                processedFiles.add(transitiveArtifactFile);
                                fileDependencyGraphUpdated = true;
                            }
                        } else {
                            throw new MojoExecutionException("Problem determining local repository for transitive file: " + transitiveArtifactFile);
                        }
                    }
                    transitivesAsImports.add(transitiveArtifactFile.getPath());
                }
            }
            List<File> artifactFiles = this.getArtifactFiles(directArtifact, targetFolder, workFolder, compileWorkFolder, localRepositoryCollector);
            for (File artifactFile : artifactFiles) {
                LinkedHashSet<String> existingImports;
                String artifactPath = artifactFile.getAbsolutePath();
                if (!processedFiles.contains(artifactFile)) {
                    String localRepository = localRepositoryCollector.findLocalRepository(artifactFile.getAbsolutePath());
                    if (localRepository != null) {
                        if (this.processFileForImportsAndSymbols(new File(localRepository), targetJsFolder, artifactFile, fileDependencyGraphModificationTime, null)) {
                            processedFiles.add(artifactFile);
                            fileDependencyGraphUpdated = true;
                        }
                    } else {
                        throw new MojoExecutionException("Problem determining local repository for file: " + artifactFile);
                    }
                }
                if (!(existingImports = this.fileDependencies.get(artifactPath)).addAll(transitivesAsImports)) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Using transitives as import: " + transitivesAsImports + " for file: " + artifactPath));
                }
                fileDependencyGraphUpdated = true;
            }
        }
        return fileDependencyGraphUpdated;
    }

    private List<File> getArtifactFiles(Artifact artifact, File targetFolder, File workFolder, File compileWorkFolder, LocalRepositoryCollector localRepositoryCollector) throws MojoExecutionException {
        JsFileArtifactHandler handler;
        try {
            boolean scopeCompile = artifact.getScope() == null ? true : artifact.getScope().equals("compile");
            handler = new JsFileArtifactHandler(artifact, targetFolder, scopeCompile ? compileWorkFolder : workFolder);
            File expansionFolder = handler.getExpansionFolder();
            if (expansionFolder != null) {
                localRepositoryCollector.addLocalRepositoryPath(expansionFolder.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot get js files from transitive artifact", (Exception)e);
        }
        return handler.getFiles();
    }

    protected void doExecute(File sourceJsFolder, File targetFolder, File workFolder, Scope scope) throws MojoExecutionException {
        boolean fileDependencyGraphUpdated;
        File compileWorkFolder;
        long fileDependencyGraphModificationTime = FileDependencyPersistanceUtil.readFileDependencyGraph(workFolder, this.fileDependencies, this.fileAssignedGlobals);
        int fileDependencyGraphHashCode = ((Object)this.fileDependencies).hashCode();
        int fileAssignedGlobalsHashCode = ((Object)this.fileAssignedGlobals).hashCode();
        if (scope == Scope.TEST) {
            compileWorkFolder = new File(workFolder.getParentFile(), "main");
            HashMap<String, LinkedHashSet<String>> compileFileDependencies = new HashMap<String, LinkedHashSet<String>>();
            FileDependencyPersistanceUtil.readFileDependencyGraph(compileWorkFolder, compileFileDependencies, this.compileFileAssignedGlobals);
        } else {
            compileWorkFolder = workFolder;
        }
        if (!this.isDependencyGraphValid()) {
            this.fileDependencies.clear();
            this.fileAssignedGlobals.clear();
            fileDependencyGraphModificationTime = 0L;
            fileDependencyGraphUpdated = true;
        } else {
            fileDependencyGraphUpdated = false;
        }
        LinkedHashSet<File> processedFiles = new LinkedHashSet<File>();
        if (this.buildDependencyGraphForDependencies(scope, fileDependencyGraphModificationTime, processedFiles, targetFolder, workFolder, compileWorkFolder)) {
            fileDependencyGraphUpdated = true;
        }
        if (this.buildDependencyGraphForChangedSourceFiles(fileDependencyGraphModificationTime, sourceJsFolder, targetFolder, processedFiles)) {
            fileDependencyGraphUpdated = true;
        }
        this.processSourceFilesForUnassignedSymbolDeclarations();
        if (fileDependencyGraphUpdated && (((Object)this.fileDependencies).hashCode() != fileDependencyGraphHashCode || ((Object)this.fileAssignedGlobals).hashCode() != fileAssignedGlobalsHashCode)) {
            FileDependencyPersistanceUtil.writeFileDependencyGraph(workFolder, this.fileDependencies, this.fileAssignedGlobals);
        }
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public Map<String, String> getFileAssignedGlobals() {
        return this.fileAssignedGlobals;
    }

    public Map<String, LinkedHashSet<String>> getFileDependencies() {
        return this.fileDependencies;
    }

    public Map<String, Set<String>> getFileUnassignedGlobals() {
        return this.fileUnassignedGlobals;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<?> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public boolean isAssumeABrowser() {
        return this.assumeABrowser;
    }

    private boolean isDependencyGraphValid() {
        boolean valid = true;
        for (String fileDependencyFilename : this.fileDependencies.keySet()) {
            File fileDependencyFile = new File(fileDependencyFilename);
            if (fileDependencyFile.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found a file that has been removed so rebuilding graph. File: " + fileDependencyFilename));
            }
            valid = false;
            break;
        }
        return valid;
    }

    private Dependency matchDirectDependency(String groupId, String artifactId) {
        Dependency dependencyFound = null;
        for (Dependency dependency : this.dependencies) {
            if (!dependency.getGroupId().equalsIgnoreCase(groupId) || !dependency.getArtifactId().equalsIgnoreCase(artifactId) || !dependency.getType().equalsIgnoreCase("js")) continue;
            dependencyFound = dependency;
            break;
        }
        return dependencyFound;
    }

    private Artifact matchTransitiveDependency(String groupId, String artifactId, Set<?> transitiveArtifacts) {
        Artifact artifactFound = null;
        for (Object transitiveArtifactObject : transitiveArtifacts) {
            Artifact transitiveArtifact = (Artifact)transitiveArtifactObject;
            if (!transitiveArtifact.getGroupId().equalsIgnoreCase(groupId) || !transitiveArtifact.getArtifactId().equalsIgnoreCase(artifactId) || !transitiveArtifact.getType().equalsIgnoreCase("js")) continue;
            artifactFound = transitiveArtifact;
            break;
        }
        return artifactFound;
    }

    protected boolean processFileForImportsAndSymbols(File sourceFolder, File targetFolder, File sourceFile, long fileDependencyGraphModificationTime, Set<?> transitiveArtifacts) throws MojoExecutionException {
        URI sourceFileRelUri = sourceFolder.toURI().relativize(sourceFile.toURI());
        File targetFile = new File(targetFolder, sourceFileRelUri.toString());
        String sourceFilePath = sourceFile.getAbsolutePath();
        if (sourceFile.lastModified() <= fileDependencyGraphModificationTime && this.fileDependencies.containsKey(sourceFilePath)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Skipping unchanged JS file: " + sourceFileRelUri));
            }
            return false;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Parsing JS file: " + sourceFileRelUri));
        }
        try {
            ANTLRFileStream cs = new ANTLRFileStream(sourceFilePath);
            ECMAScriptLexer lexer = new ECMAScriptLexer((CharStream)cs);
            lexer.setSourceFile(sourceFileRelUri, sourceFile.getName());
            CommonTokenStream tokenStream = new CommonTokenStream();
            tokenStream.setTokenSource((TokenSource)lexer);
            this.writeTokenStream((CharStream)cs, tokenStream, targetFile);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Assigned globals: " + lexer.getAssignedGlobalVars().toString()));
                this.getLog().debug((CharSequence)("Unassigned globals: " + lexer.getUnassignedGlobalVars().toString()));
                this.getLog().debug((CharSequence)("Imports: " + lexer.getImportGavs().toString()));
            }
            for (String assignedGlobalVar : lexer.getAssignedGlobalVars()) {
                this.fileAssignedGlobals.put(assignedGlobalVar, sourceFilePath);
            }
            HashSet<String> vars = new HashSet<String>(lexer.getUnassignedGlobalVars());
            if (this.assumeABrowser) {
                vars.removeAll(Arrays.asList("clearInterval", "clearTimeout", "document", "exports", "event", "frames", "history", "Image", "location", "module", "name", "navigator", "Option", "parent", "require", "screen", "setInterval", "setTimeout", "window", "XMLHttpRequest"));
            }
            this.fileUnassignedGlobals.put(sourceFilePath, vars);
            LinkedHashSet<String> importedDependencies = new LinkedHashSet<String>(lexer.getImportGavs().size());
            this.fileDependencies.put(sourceFilePath, importedDependencies);
            for (ECMAScriptLexer.GAV importGav : lexer.getImportGavs()) {
                Artifact artifactFound;
                Dependency dependencyFound = this.matchDirectDependency(importGav.groupId, importGav.artifactId);
                if (dependencyFound == null) {
                    artifactFound = transitiveArtifacts != null ? this.matchTransitiveDependency(importGav.groupId, importGav.artifactId, transitiveArtifacts) : null;
                    if (artifactFound == null) {
                        this.getLog().error((CharSequence)("Dependency not found: " + importGav.groupId + ":" + importGav.artifactId));
                        throw new MojoExecutionException("Build stopping given dependency issue.");
                    }
                } else {
                    artifactFound = this.resolveArtifact(dependencyFound);
                }
                importedDependencies.add(artifactFound.getFile().getPath());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Found import: " + importGav.groupId + ":" + importGav.artifactId + " (" + artifactFound.getFile().getName() + ") for file: " + sourceFileRelUri));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem opening file: " + sourceFileRelUri, (Exception)e);
        }
        return true;
    }

    protected void processSourceFilesForUnassignedSymbolDeclarations() throws MojoExecutionException {
        Set<Map.Entry<String, Set<String>>> entrySet = this.fileUnassignedGlobals.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String variableDeclFile = entry.getKey();
            for (String variableName : entry.getValue()) {
                String variableAssignedFile = this.fileAssignedGlobals.get(variableName);
                if (variableAssignedFile == null && this.compileFileAssignedGlobals != null) {
                    variableAssignedFile = this.compileFileAssignedGlobals.get(variableName);
                }
                if (variableAssignedFile == null) {
                    this.getLog().error((CharSequence)("Dependency not found: " + variableName + " in file: " + variableDeclFile));
                    throw new MojoExecutionException("Build stopping given dependency issue.");
                }
                LinkedHashSet<String> variableDeclFileImports = this.fileDependencies.get(variableDeclFile);
                if (variableDeclFileImports == null) {
                    variableDeclFileImports = new LinkedHashSet();
                    this.fileDependencies.put(variableDeclFile, variableDeclFileImports);
                }
                variableDeclFileImports.add(variableAssignedFile);
            }
        }
    }

    private Artifact resolveArtifact(Dependency dependency) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(dependency.toString(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(dependency.toString(), (Exception)((Object)e));
        }
        return artifact;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
        this.artifactMetadataSource = artifactMetadataSource;
    }

    public void setAssumeABrowser(boolean assumeABrowser) {
        this.assumeABrowser = assumeABrowser;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setRemoteRepositories(List<?> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTokenStream(CharStream cs, CommonTokenStream tokenStream, File outputFile) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(FileUtils.openOutputStream((File)outputFile));
        try {
            int streamChar;
            List tokens = tokenStream.getTokens();
            cs.seek(0);
            for (Object tokenObject : tokens) {
                int streamChar2;
                CommonToken token = (CommonToken)tokenObject;
                if (token.getType() != 15 && token.getType() != 16) continue;
                int startIndex = token.getStartIndex();
                while (cs.index() < startIndex && (streamChar2 = cs.LA(1)) != -1) {
                    ((OutputStream)os).write(streamChar2);
                    cs.consume();
                }
                StringCharacterIterator iter = new StringCharacterIterator(token.getText());
                char tokenChar = iter.first();
                while (tokenChar != '\uffff') {
                    ((OutputStream)os).write(tokenChar);
                    tokenChar = iter.next();
                }
                cs.seek(token.getStopIndex() + 1);
            }
            while ((streamChar = cs.LA(1)) != -1) {
                ((OutputStream)os).write(streamChar);
                cs.consume();
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Scope {
        COMPILE,
        TEST;

    }

    private class ArtifactId {
        private final String groupId;
        private final String artifactId;

        public ArtifactId(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ArtifactId)) {
                return false;
            }
            ArtifactId other = (ArtifactId)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }

        private AbstractImportMojo getOuterType() {
            return AbstractImportMojo.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            return result;
        }
    }
}

