/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss.packaging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:jboss-packaging-maven-plugin:2.1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "JBoss Packaging Maven Plugin", 0);
        this.append(sb, "Maven plugin for generated JAR-based packagings for deployment to JBoss.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "esb".equals(this.goal)) {
            this.append(sb, "jboss-packaging:esb", 0);
            this.append(sb, "Builds a JBoss ESB Archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-esb.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-esb.xml) If it is present in src/main/resources/META-INF then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentXml", 2);
                this.append(sb, "Override the deployment xml file", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "esb-exploded".equals(this.goal)) {
            this.append(sb, "jboss-packaging:esb-exploded", 0);
            this.append(sb, "Deprecated. Use esb goal with 'explodedOnly' parameter", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Builds a JBoss ESB exploded Archive.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-esb.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-esb.xml) If it is present in src/main/resources/META-INF then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentXml", 2);
                this.append(sb, "Override the deployment xml file", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "har".equals(this.goal)) {
            this.append(sb, "jboss-packaging:har", 0);
            this.append(sb, "Build a deployable JBoss Hibernate Archive. Note that in versions of jboss prior to 4.0.3 the deployment descriptor for a HAR was 'hibernate-service.xml'. In 4.0.3 this changed to use 'jboss-service.xml' similar to the SAR format. In JBoss 5 and above, the HAR deployment descriptor can be any file with a name that matches the pattern '*-hibernate.xml'. If the parameter 'deploymentDescriptorFile' is not set, this goal will first look for 'jboss-service.xml', then 'hibernate-service.xml' and if those are not found, it will search for a file ending with * '-hibernate.xml'", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile", 2);
                this.append(sb, "The name of the hibernate deployment descriptor file. If left blank, the goal will automatically search for 'jboss-service.xml', 'hibernate-service.xml', and '*-hibernate.xml' in that order.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "har-exploded".equals(this.goal)) {
            this.append(sb, "jboss-packaging:har-exploded", 0);
            this.append(sb, "Deprecated. Use har goal with 'explodedOnly' parameter", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Build a JBoss Hibernate exploded Archive.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile", 2);
                this.append(sb, "The name of the hibernate deployment descriptor file. If left blank, the goal will automatically search for 'jboss-service.xml', 'hibernate-service.xml', and '*-hibernate.xml' in that order.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jboss-packaging:help", 0);
            this.append(sb, "Display help information on jboss-packaging-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jboss-packaging:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "par".equals(this.goal)) {
            this.append(sb, "jboss-packaging:par", 0);
            this.append(sb, "Build a deployable JBoss Process Archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.directory}/${project.build.finalName}/processdefinition.xml)", 2);
                this.append(sb, "The location of the jbpm deployment descriptor file (processdefinition.xml) If it is present in src/main/resources then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding of the resource files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters (Default: ${project.build.filters})", 2);
                this.append(sb, "The filters used when copying the resource files. By default this will use the resource filters specified in the POM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbpmDirectory (Default: src/main/jbpm)", 2);
                this.append(sb, "The directory where JBoss JBPM resources are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jpdlDirectory (Default: src/main/jpdl/${project.artifactId})", 2);
                this.append(sb, "The directory where JBoss JPDL resources are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingClassesDirectory (Default: ${project.build.directory}/${project.build.finalName}/classes)", 2);
                this.append(sb, "The directory where compiled classes and resources are placed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
                this.append(sb, "resources", 2);
                this.append(sb, "The resources to include in the packaged archive. Specifying this overrides using jbpmDirectory and jpdlDirectory.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sar".equals(this.goal)) {
            this.append(sb, "jboss-packaging:sar", 0);
            this.append(sb, "Build a deployable JBoss Service Archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-service.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-service.xml) If it is present in src/main/resources/META-INF then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sar-exploded".equals(this.goal)) {
            this.append(sb, "jboss-packaging:sar-exploded", 0);
            this.append(sb, "Deprecated. Use sar goal with 'explodedOnly' parameter", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Build a JBoss Service exploded Archive.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-service.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-service.xml) If it is present in src/main/resources/META-INF then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sar-inplace".equals(this.goal)) {
            this.append(sb, "jboss-packaging:sar-inplace", 0);
            this.append(sb, "Deprecated. Use sar goal with 'explodedOnly' parameter", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Build a JBoss Service in place exploded Archive.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-service.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-service.xml) If it is present in src/main/resources/META-INF then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "spring".equals(this.goal)) {
            this.append(sb, "jboss-packaging:spring", 0);
            this.append(sb, "Build a deployable JBoss Spring Archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The maven archive configuration to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "archiveName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the generated packaging archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the generated artifact. If given, the artifact not be the primary project artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDest (Default: ${project.build.directory}/${project.build.finalName}/META-INF)", 2);
                this.append(sb, "The destination of the deployment descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorDestName", 2);
                this.append(sb, "The filename for the output deployment descriptor. By default the deployment descriptor will retain the same filename.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentDescriptorFile (Default: ${project.build.outputDirectory}/META-INF/jboss-spring.xml)", 2);
                this.append(sb, "The location of the jboss deployment descriptor file (jboss-spring.xml). If it is present in src/main/resources/META-INF with that name then it will automatically be included. Otherwise this parameter must be set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeAll (Default: false)", 2);
                this.append(sb, "All artifacts are excluded", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Dependency Artifacts excluded from packaging within the generated archive file. Use artifactId:groupId in nested exclude tags.", 3);
                this.append(sb, "", 0);
                this.append(sb, "explodedOnly (Default: false)", 2);
                this.append(sb, "Whether to generate only the exploded sar format. By default both an exploded directory and a zipped file will be created. If set to 'true' only the exploded directory will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: ${project.build.directory}/${project.build.finalName}/lib)", 2);
                this.append(sb, "The directory where to put the libs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "manifest", 2);
                this.append(sb, "The manifest file for the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for the generated packaging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagingDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the JBoss packaging is built.", 3);
                this.append(sb, "", 0);
                this.append(sb, "primaryArtifact (Default: true)", 2);
                this.append(sb, "Whether this is the main artifact of the current project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeDependencyVersions (Default: false)", 2);
                this.append(sb, "Whether to remove the version numbers from the filenames of the included dependencies. By default the included dependencies will have the format [artifactId]-[version]-[classifier].[type] If this parameter is set to true, the jar name will be in the format [artifactId]-[classifier].[type]", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

